"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDataCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _illustration_product_no_results_magnifying_glass = _interopRequireDefault(require("./assets/illustration_product_no_results_magnifying_glass.svg"));
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoDataCallout = ({
  'data-test-subj': dateTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dateTestSubj);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      height: 490
    },
    alignItems: "center",
    justifyContent: "center",
    "data-test-subj": getTestId('no-charts-callout')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    style: {
      maxWidth: 500
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataUsage.noCharts.title",
    defaultMessage: "No chart data without data streams"
  }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataUsage.noCharts.description",
    defaultMessage: "Try searching with at least one data stream."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    style: {
      width: 200,
      height: 148
    },
    size: "200",
    alt: "",
    url: _illustration_product_no_results_magnifying_glass.default
  }))))));
};
exports.NoDataCallout = NoDataCallout;
NoDataCallout.displayName = 'NoDataCallout';