"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamAdapter = void 0;
var _indexAdapter = require("@kbn/index-adapter");
var _create_or_update_data_stream = require("./create_or_update_data_stream");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataStreamAdapter extends _indexAdapter.IndexAdapter {
  setIndexTemplate(params) {
    super.setIndexTemplate({
      ...params,
      isDataStream: true
    });
  }
  async install(params) {
    this.installed = true;
    const {
      logger,
      pluginStop$,
      tasksTimeoutMs
    } = params;
    const esClient = await params.esClient;
    await this.installTemplates(params);
    const installFn = this.getInstallFn({
      logger,
      pluginStop$,
      tasksTimeoutMs
    });

    // create data stream when everything is ready
    await installFn((0, _create_or_update_data_stream.createOrUpdateDataStream)({
      name: this.name,
      esClient,
      logger,
      totalFieldsLimit: this.totalFieldsLimit,
      writeIndexOnly: this.writeIndexOnly
    }), `${this.name} data stream`);
  }
}
exports.DataStreamAdapter = DataStreamAdapter;