"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPanelButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _add_panel_flyout = require("./add_panel_flyout");
var _use_dashboard_api = require("../../../../dashboard_api/use_dashboard_api");
var _kibana_services = require("../../../../services/kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const AddPanelButton = ({
  isDisabled
}) => {
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  (0, _react.useEffect)(() => {
    // ensure opened overlays are closed if a navigation event happens
    return () => {
      dashboardApi.clearOverlays();
    };
  }, [dashboardApi]);
  const openFlyout = (0, _react.useCallback)(() => {
    const overlayRef = _kibana_services.coreServices.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(function () {
      return /*#__PURE__*/_react.default.createElement(_add_panel_flyout.AddPanelFlyout, {
        dashboardApi: dashboardApi
      });
    }), _kibana_services.coreServices), {
      size: 'm',
      maxWidth: 500,
      paddingSize: 'm',
      'aria-labelledby': 'addPanelsFlyout',
      'data-test-subj': 'dashboardPanelSelectionFlyout',
      onClose() {
        dashboardApi.clearOverlays();
        overlayRef.close();
      }
    });
    dashboardApi.openOverlay(overlayRef);
  }, [dashboardApi]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
    "data-test-subj": "dashboardEditorMenuButton",
    isDisabled: isDisabled,
    iconType: "plusInCircle",
    label: _i18n.i18n.translate('dashboard.solutionToolbar.editorMenuButtonLabel', {
      defaultMessage: 'Add panel'
    }),
    onClick: openFlyout,
    size: "s"
  });
};
exports.AddPanelButton = AddPanelButton;