"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSerializedState = exports.convertTimeToUTCString = void 0;
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _content_management = require("../../common/content_management");
var _dashboard_versioning = require("../services/dashboard_content_management_service/lib/dashboard_versioning");
var _kibana_services = require("../services/kibana_services");
var _generate_new_panel_ids = require("./generate_new_panel_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LATEST_DASHBOARD_CONTAINER_VERSION = (0, _dashboard_versioning.convertNumberToDashboardVersion)(_content_management.LATEST_VERSION);
const convertTimeToUTCString = time => {
  if ((0, _moment.default)(time).isValid()) {
    return (0, _moment.default)(time).utc().format('YYYY-MM-DDTHH:mm:ss.SSS[Z]');
  } else {
    // If it's not a valid moment date, then it should be a string representing a relative time
    // like 'now' or 'now-15m'.
    return time;
  }
};
exports.convertTimeToUTCString = convertTimeToUTCString;
const getSerializedState = ({
  controlGroupReferences,
  generateNewIds,
  dashboardState,
  panelReferences,
  searchSourceReferences
}) => {
  var _prefixedPanelReferen;
  const {
    query: {
      timefilter: {
        timefilter
      }
    }
  } = _kibana_services.dataService;
  const {
    tags,
    query,
    title,
    filters,
    timeRestore,
    description,
    // Dashboard options
    useMargins,
    syncColors,
    syncCursor,
    syncTooltips,
    hidePanelTitles,
    controlGroupInput
  } = dashboardState;
  let {
    panels
  } = dashboardState;
  let prefixedPanelReferences = panelReferences;
  if (generateNewIds) {
    const {
      newPanels,
      newPanelReferences
    } = (0, _generate_new_panel_ids.generateNewPanelIds)(panels, panelReferences);
    panels = newPanels;
    prefixedPanelReferences = newPanelReferences;
    //
    // do not need to generate new ids for controls.
    // ControlGroup Component is keyed on dashboard id so changing dashboard id mounts new ControlGroup Component.
    //
  }
  const searchSource = {
    filter: filters,
    query
  };
  const options = {
    useMargins,
    syncColors,
    syncCursor,
    syncTooltips,
    hidePanelTitles
  };

  /**
   * Parse global time filter settings
   */
  const {
    from,
    to
  } = timefilter.getTime();
  const timeFrom = timeRestore ? convertTimeToUTCString(from) : undefined;
  const timeTo = timeRestore ? convertTimeToUTCString(to) : undefined;
  const refreshInterval = timeRestore ? (0, _lodash.pick)(timefilter.getRefreshInterval(), ['display', 'pause', 'section', 'value']) : undefined;
  const attributes = {
    version: (0, _dashboard_versioning.convertDashboardVersionToNumber)(LATEST_DASHBOARD_CONTAINER_VERSION),
    controlGroupInput: controlGroupInput,
    kibanaSavedObjectMeta: {
      searchSource
    },
    description: description !== null && description !== void 0 ? description : '',
    refreshInterval,
    timeRestore,
    options,
    panels,
    timeFrom,
    title,
    timeTo
  };

  // TODO Provide tags as an array of tag names in the attribute. In that case, tag references
  // will be extracted by the server.
  const savedObjectsTaggingApi = _kibana_services.savedObjectsTaggingService === null || _kibana_services.savedObjectsTaggingService === void 0 ? void 0 : _kibana_services.savedObjectsTaggingService.getTaggingApi();
  const references = savedObjectsTaggingApi !== null && savedObjectsTaggingApi !== void 0 && savedObjectsTaggingApi.ui.updateTagsReferences ? savedObjectsTaggingApi === null || savedObjectsTaggingApi === void 0 ? void 0 : savedObjectsTaggingApi.ui.updateTagsReferences(searchSourceReferences !== null && searchSourceReferences !== void 0 ? searchSourceReferences : [], tags) : searchSourceReferences !== null && searchSourceReferences !== void 0 ? searchSourceReferences : [];
  const allReferences = [...references, ...((_prefixedPanelReferen = prefixedPanelReferences) !== null && _prefixedPanelReferen !== void 0 ? _prefixedPanelReferen : []), ...(controlGroupReferences !== null && controlGroupReferences !== void 0 ? controlGroupReferences : []), ...(searchSourceReferences !== null && searchSourceReferences !== void 0 ? searchSourceReferences : [])];
  return {
    attributes,
    references: allReferences
  };
};
exports.getSerializedState = getSerializedState;