"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrossClusterReplicationHome = void 0;
var _reactRedux = require("react-redux");
var _constants = require("../../constants");
var _selectors = require("../../store/selectors");
var _home = require("./home");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => ({
  autoFollowPatterns: (0, _selectors.getListAutoFollowPatterns)(state),
  isAutoFollowApiAuthorized: (0, _selectors.isApiAuthorized)(_constants.SECTIONS.AUTO_FOLLOW_PATTERN)(state),
  followerIndices: (0, _selectors.getListFollowerIndices)(state),
  isFollowerIndexApiAuthorized: (0, _selectors.isApiAuthorized)(_constants.SECTIONS.FOLLOWER_INDEX)(state)
});
const CrossClusterReplicationHome = exports.CrossClusterReplicationHome = (0, _reactRedux.connect)(mapStateToProps, null)(_home.CrossClusterReplicationHome);