"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.performIncrementCounter = void 0;
var _lodash = require("lodash");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _internals = require("./internals");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const performIncrementCounter = async ({
  type,
  id,
  counterFields,
  options
}, apiExecutionContext) => {
  const {
    allowedTypes
  } = apiExecutionContext;
  // This is not exposed on the SOC, there are no authorization or audit logging checks
  if (typeof type !== 'string') {
    throw new Error('"type" argument must be a string');
  }
  const isArrayOfCounterFields = Array.isArray(counterFields) && counterFields.every(field => typeof field === 'string' || (0, _lodash.isObject)(field) && typeof field.fieldName === 'string');
  if (!isArrayOfCounterFields) {
    throw new Error('"counterFields" argument must be of type Array<string | { incrementBy?: number; fieldName: string }>');
  }
  if (!allowedTypes.includes(type)) {
    throw _coreSavedObjectsServer.SavedObjectsErrorHelpers.createUnsupportedTypeError(type);
  }
  return (0, _internals.incrementCounterInternal)({
    type,
    id,
    counterFields,
    options
  }, apiExecutionContext);
};
exports.performIncrementCounter = performIncrementCounter;