"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToastsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _global_toast_list = require("./global_toast_list");
var _toasts_api = require("./toasts_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ToastsService {
  constructor() {
    (0, _defineProperty2.default)(this, "api", void 0);
    (0, _defineProperty2.default)(this, "targetDomElement", void 0);
  }
  setup({
    uiSettings
  }) {
    this.api = new _toasts_api.ToastsApi({
      uiSettings
    });
    return this.api;
  }
  start({
    eventReporter,
    overlays,
    targetDomElement,
    rendering
  }) {
    this.api.start({
      overlays,
      rendering
    });
    this.targetDomElement = targetDomElement;
    (0, _reactDom.render)(rendering.addContext(/*#__PURE__*/_react.default.createElement(_global_toast_list.GlobalToastList, {
      dismissToast: toastId => this.api.remove(toastId),
      toasts$: this.api.get$(),
      reportEvent: eventReporter
    })), targetDomElement);
    return this.api;
  }
  stop() {
    if (this.targetDomElement) {
      (0, _reactDom.unmountComponentAtNode)(this.targetDomElement);
      this.targetDomElement.textContent = '';
    }
  }
}
exports.ToastsService = ToastsService;