"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventReporter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _event_types = require("./event_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EventReporter {
  constructor({
    analytics
  }) {
    (0, _defineProperty2.default)(this, "reportEvent", void 0);
    this.reportEvent = analytics.reportEvent;
  }
  onDismissToast({
    recurrenceCount,
    toastMessage,
    toastMessageType
  }) {
    this.reportEvent(_event_types.EventMetric.TOAST_DISMISSED, {
      [_event_types.FieldType.RECURRENCE_COUNT]: recurrenceCount,
      [_event_types.FieldType.TOAST_MESSAGE]: toastMessage,
      [_event_types.FieldType.TOAST_MESSAGE_TYPE]: toastMessageType
    });
  }
}
exports.EventReporter = EventReporter;