"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = Header;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _collapsible_nav = require("./collapsible_nav");
var _header_badge = require("./header_badge");
var _header_breadcrumbs = require("./header_breadcrumbs");
var _header_help_menu = require("./header_help_menu");
var _header_logo = require("./header_logo");
var _header_nav_controls = require("./header_nav_controls");
var _header_action_menu = require("./header_action_menu");
var _header_extension = require("./header_extension");
var _header_top_banner = require("./header_top_banner");
var _header_menu_button = require("./header_menu_button");
var _screen_reader_a11y = require("./screen_reader_a11y");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function Header({
  kibanaVersion,
  kibanaDocLink,
  docLinks,
  application,
  basePath,
  onIsLockedUpdate,
  homeHref,
  breadcrumbsAppendExtension$,
  globalHelpExtensionMenuLinks$,
  customBranding$,
  isServerless,
  ...observables
}) {
  const [isNavOpen, setIsNavOpen] = (0, _react.useState)(false);
  const [navId] = (0, _react.useState)((0, _eui.htmlIdGenerator)()());
  const breadcrumbsAppendExtension = (0, _useObservable.default)(breadcrumbsAppendExtension$);
  const headerActionMenuMounter = (0, _header_action_menu.useHeaderActionMenuMounter)(application.currentActionMenu$);
  const toggleCollapsibleNavRef = /*#__PURE__*/(0, _react.createRef)();
  const className = (0, _classnames.default)('hide-for-sharing', 'headerGlobalNav');
  const Breadcrumbs = /*#__PURE__*/_react.default.createElement(_header_breadcrumbs.HeaderBreadcrumbs, {
    breadcrumbs$: observables.breadcrumbs$
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_screen_reader_a11y.ScreenReaderRouteAnnouncements, {
    breadcrumbs$: observables.breadcrumbs$,
    customBranding$: customBranding$,
    appId$: application.currentAppId$
  }), /*#__PURE__*/_react.default.createElement(_screen_reader_a11y.SkipToMainContent, null), /*#__PURE__*/_react.default.createElement(_header_top_banner.HeaderTopBanner, {
    headerBanner$: observables.headerBanner$
  }), /*#__PURE__*/_react.default.createElement("header", {
    className: className,
    "data-test-subj": "headerGlobalNav"
  }, /*#__PURE__*/_react.default.createElement("div", {
    id: "globalHeaderBars",
    className: "header__bars"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeader, {
    theme: "dark",
    position: "fixed",
    className: "header__firstBar",
    sections: [{
      items: [/*#__PURE__*/_react.default.createElement(_header_logo.HeaderLogo, {
        href: homeHref,
        forceNavigation$: observables.forceAppSwitcherNavigation$,
        navLinks$: observables.navLinks$,
        navigateToApp: application.navigateToApp,
        loadingCount$: observables.loadingCount$,
        customBranding$: customBranding$
      })]
    }, {
      ...(observables.navControlsCenter$ && {
        items: [/*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
          sizes: ['m', 'l', 'xl']
        }, /*#__PURE__*/_react.default.createElement(_header_nav_controls.HeaderNavControls, {
          navControls$: observables.navControlsCenter$
        }))]
      })
    }, {
      items: [/*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
        sizes: ['m', 'l', 'xl']
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header_nav_controls.HeaderNavControls, {
        navControls$: observables.navControlsExtension$
      }), /*#__PURE__*/_react.default.createElement(_header_nav_controls.HeaderNavControls, {
        navControls$: observables.navControlsCenter$
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
        sizes: ['xs', 's']
      }, /*#__PURE__*/_react.default.createElement(_header_nav_controls.HeaderNavControls, {
        navControls$: observables.navControlsExtension$
      })), /*#__PURE__*/_react.default.createElement(_header_help_menu.HeaderHelpMenu, {
        isServerless: isServerless,
        globalHelpExtensionMenuLinks$: globalHelpExtensionMenuLinks$,
        helpExtension$: observables.helpExtension$,
        helpSupportUrl$: observables.helpSupportUrl$,
        defaultContentLinks$: observables.helpMenuLinks$,
        kibanaDocLink: kibanaDocLink,
        docLinks: docLinks,
        kibanaVersion: kibanaVersion,
        navigateToUrl: application.navigateToUrl
      }), /*#__PURE__*/_react.default.createElement(_header_nav_controls.HeaderNavControls, {
        navControls$: observables.navControlsRight$
      })]
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHeader, {
    position: "fixed",
    className: "header__secondBar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, {
    className: "header__toggleNavButtonSection"
  }, /*#__PURE__*/_react.default.createElement(_collapsible_nav.CollapsibleNav, {
    appId$: application.currentAppId$,
    id: navId,
    navLinks$: observables.navLinks$,
    recentlyAccessed$: observables.recentlyAccessed$,
    isNavOpen: isNavOpen,
    homeHref: homeHref,
    basePath: basePath,
    navigateToApp: application.navigateToApp,
    navigateToUrl: application.navigateToUrl,
    onIsLockedUpdate: onIsLockedUpdate,
    closeNav: () => {
      setIsNavOpen(false);
    },
    customNavLink$: observables.customNavLink$,
    button: /*#__PURE__*/_react.default.createElement(_header_menu_button.HeaderMenuButton, {
      "data-test-subj": "toggleNavButton",
      "aria-label": _i18n.i18n.translate('core.ui.primaryNav.header.toggleNavAriaLabel', {
        defaultMessage: 'Toggle primary navigation'
      }),
      onClick: () => setIsNavOpen(!isNavOpen),
      "aria-expanded": isNavOpen,
      "aria-pressed": isNavOpen,
      "aria-controls": navId,
      forwardRef: toggleCollapsibleNavRef
    })
  })), /*#__PURE__*/_react.default.createElement(_header_nav_controls.HeaderNavControls, {
    side: "left",
    navControls$: observables.navControlsLeft$
  })), !breadcrumbsAppendExtension ? Breadcrumbs : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: false,
    alignItems: 'center',
    className: 'header__breadcrumbsWithExtensionContainer',
    gutterSize: 'none'
  }, Breadcrumbs, /*#__PURE__*/_react.default.createElement(_header_extension.HeaderExtension, {
    extension: breadcrumbsAppendExtension.content,
    containerClassName: 'header__breadcrumbsAppendExtension'
  })), /*#__PURE__*/_react.default.createElement(_header_badge.HeaderBadge, {
    badge$: observables.badge$
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, {
    side: "right"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_header_action_menu.HeaderActionMenu, {
    mounter: headerActionMenuMounter
  })))))));
}