"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricTiles = exports.MetricTile = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lib = require("../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * Displays metadata for a metric.
 */
const MetricCardFooter = ({
  title,
  description
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "serverMetricMeta",
    title: title,
    titleSize: "xxs",
    description: description,
    reverse: true
  });
};
const DelayMetricTile = ({
  metric
}) => {
  const {
    name,
    meta
  } = metric;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": `serverMetric-${formatMetricId(name)}`,
    title: formatMetric(metric),
    textAlign: "left",
    description: `${name} avg`,
    footer: (meta === null || meta === void 0 ? void 0 : meta.value) && /*#__PURE__*/_react.default.createElement(MetricCardFooter, {
      title: formatDelayFooterTitle(meta.value, meta.type),
      description: meta.description
    })
  });
};
const LoadMetricTile = ({
  metric
}) => {
  const {
    name,
    meta
  } = metric;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": `serverMetric-${formatMetricId(name)}`,
    title: formatMetric(metric),
    textAlign: "left",
    description: name,
    footer: meta && /*#__PURE__*/_react.default.createElement(MetricCardFooter, {
      title: meta.title,
      description: meta.description
    })
  });
};
const ResponseTimeMetric = ({
  metric
}) => {
  const {
    name,
    meta
  } = metric;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": `serverMetric-${formatMetricId(name)}`,
    title: formatMetric(metric),
    textAlign: "left",
    description: name,
    footer: (meta === null || meta === void 0 ? void 0 : meta.value) && Array.isArray(meta.value) && /*#__PURE__*/_react.default.createElement(MetricCardFooter, {
      title: (0, _lib.formatNumber)(meta.value[0], meta.type),
      description: meta.description
    })
  });
};

/*
 * Displays a metric with the correct format.
 */
const MetricTile = ({
  metric
}) => {
  const {
    name
  } = metric;
  switch (name) {
    case 'Delay':
      return /*#__PURE__*/_react.default.createElement(DelayMetricTile, {
        metric: metric
      });
    case 'Load':
      return /*#__PURE__*/_react.default.createElement(LoadMetricTile, {
        metric: metric
      });
    case 'Response time avg':
      return /*#__PURE__*/_react.default.createElement(ResponseTimeMetric, {
        metric: metric
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
        "data-test-subj": `serverMetric-${formatMetricId(name)}`,
        textAlign: "left",
        title: formatMetric(metric),
        description: name
      });
  }
};

/*
 * Wrapper component that simply maps each metric to MetricTile inside a FlexGroup
 */
exports.MetricTile = MetricTile;
const MetricTiles = ({
  metrics
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
  columns: 3
}, metrics.map(metric => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  key: metric.name,
  "data-test-subj": "serverMetric"
}, /*#__PURE__*/_react.default.createElement(MetricTile, {
  metric: metric
}))));

// formatting helper functions
exports.MetricTiles = MetricTiles;
const formatMetric = ({
  value,
  type
}) => {
  const metrics = Array.isArray(value) ? value : [value];
  return metrics.map(metric => (0, _lib.formatNumber)(metric, type)).join(', ');
};
const formatMetricId = name => {
  return name.toLowerCase().replace(/[ ]+/g, '-');
};
const formatDelayFooterTitle = (values, type) => {
  return `
  50: ${(0, _lib.formatNumber)(values[0], type)};
  95: ${(0, _lib.formatNumber)(values[1], type)};
  99: ${(0, _lib.formatNumber)(values[2], type)}`;
};