"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasNoResults$ = hasNoResults$;
var _rxjs = require("rxjs");
var _kibana_services = require("../../../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function hasNoResults$({
  controlFetch$,
  dataViews$,
  rangeFilters$,
  ignoreParentSettings$,
  setIsLoading
}) {
  let prevRequestAbortController;
  return (0, _rxjs.combineLatest)([controlFetch$, rangeFilters$, ignoreParentSettings$]).pipe((0, _rxjs.tap)(() => {
    if (prevRequestAbortController) {
      prevRequestAbortController.abort();
      prevRequestAbortController = undefined;
    }
  }), (0, _rxjs.switchMap)(async ([controlFetchContext, rangeFilters, ignoreParentSettings]) => {
    var _dataViews$$value;
    const dataView = dataViews$ === null || dataViews$ === void 0 ? void 0 : (_dataViews$$value = dataViews$.value) === null || _dataViews$$value === void 0 ? void 0 : _dataViews$$value[0];
    const rangeFilter = rangeFilters === null || rangeFilters === void 0 ? void 0 : rangeFilters[0];
    if (!dataView || !rangeFilter || ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreValidations) {
      return false;
    }
    try {
      setIsLoading(true);
      const abortController = new AbortController();
      prevRequestAbortController = abortController;
      return await hasNoResults({
        abortSignal: abortController.signal,
        dataView,
        rangeFilter,
        ...controlFetchContext
      });
    } catch (error) {
      // Ignore error, validation is not required for control to function properly
      return false;
    }
  }), (0, _rxjs.tap)(() => {
    setIsLoading(false);
  }));
}
async function hasNoResults({
  abortSignal,
  dataView,
  filters,
  query,
  rangeFilter,
  timeRange
}) {
  var _value, _resp$rawResponse, _resp$rawResponse$hit, _resp$rawResponse$hit2;
  const searchSource = await _kibana_services.dataService.search.searchSource.create();
  searchSource.setField('size', 0);
  searchSource.setField('index', dataView);
  // Tracking total hits accurately has a performance cost
  // Setting 'trackTotalHits' to 1 since we just want to know
  // "has no results" or "has results" vs the actual count
  searchSource.setField('trackTotalHits', 1);
  const allFilters = filters ? [...filters] : [];
  allFilters.push(rangeFilter);
  if (timeRange) {
    const timeFilter = _kibana_services.dataService.query.timefilter.timefilter.createFilter(dataView, timeRange);
    if (timeFilter) allFilters.push(timeFilter);
  }
  if (allFilters.length) {
    searchSource.setField('filter', allFilters);
  }
  if (query) {
    searchSource.setField('query', query);
  }
  const resp = await (0, _rxjs.lastValueFrom)(searchSource.fetch$({
    abortSignal,
    legacyHitsTotal: false
  }));
  const count = (_value = resp === null || resp === void 0 ? void 0 : (_resp$rawResponse = resp.rawResponse) === null || _resp$rawResponse === void 0 ? void 0 : (_resp$rawResponse$hit = _resp$rawResponse.hits) === null || _resp$rawResponse$hit === void 0 ? void 0 : (_resp$rawResponse$hit2 = _resp$rawResponse$hit.total) === null || _resp$rawResponse$hit2 === void 0 ? void 0 : _resp$rawResponse$hit2.value) !== null && _value !== void 0 ? _value : 0;
  return count === 0;
}