"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VariableEditorForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _uuid = require("uuid");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fieldsConfig = {
  variableName: {
    label: _i18n.i18n.translate('console.variablesPage.form.variableNameFieldLabel', {
      defaultMessage: 'Variable name'
    }),
    validations: [{
      validator: ({
        value
      }) => {
        if (value.trim() === '') {
          return {
            message: _i18n.i18n.translate('console.variablesPage.form.variableNameRequiredLabel', {
              defaultMessage: 'This is a required field'
            })
          };
        }
        if (!(0, _utils.isValidVariableName)(value)) {
          return {
            message: _i18n.i18n.translate('console.variablesPage.form.variableNameInvalidLabel', {
              defaultMessage: 'Only letters, numbers and underscores are allowed'
            })
          };
        }
      }
    }]
  },
  value: {
    label: _i18n.i18n.translate('console.variablesPage.form.valueFieldLabel', {
      defaultMessage: 'Value'
    }),
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('console.variablesPage.form.valueRequiredLabel', {
        defaultMessage: 'Value is required'
      }))
    }]
  }
};
const VariableEditorForm = props => {
  var _props$title;
  const onSubmit = async (data, isValid) => {
    if (isValid) {
      props.onSubmit({
        ...props.defaultValue,
        ...data,
        ...(props.defaultValue ? {} : {
          id: (0, _uuid.v4)()
        })
      });
    }
  };
  const {
    form
  } = (0, _shared_imports.useForm)({
    onSubmit,
    defaultValue: props.defaultValue
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    borderRadius: "none",
    grow: false,
    css: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, (_props$title = props.title) !== null && _props$title !== void 0 ? _props$title : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Add a new variable",
    id: "console.variablesPage.addNewVariableTitle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.variableName,
    path: "name",
    component: _shared_imports.TextField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'nameField',
        placeholder: _i18n.i18n.translate('console.variablesPage.form.namePlaceholderLabel', {
          defaultMessage: 'exampleName'
        }),
        prepend: '${',
        append: '}'
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.value,
    path: "value",
    component: _shared_imports.TextField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'valueField',
        placeholder: _i18n.i18n.translate('console.variablesPage.form.valuePlaceholderLabel', {
          defaultMessage: 'exampleValue'
        })
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => props.onCancel()
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.variablesPage.addNew.cancelButton",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "save",
    onClick: form.submit,
    "data-test-subj": "addNewVariableButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.variablesPage.addNew.submitButton",
    defaultMessage: "Save changes"
  })))))));
};
exports.VariableEditorForm = VariableEditorForm;