"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Configurations = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/usage-collection-plugin/public");
var _use_csp_setup_status_api = require("@kbn/cloud-security-posture/src/hooks/use_csp_setup_status_api");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _use_data_view = require("@kbn/cloud-security-posture/src/hooks/use_data_view");
var _eui = require("@elastic/eui");
var _no_findings_states = require("../../components/no_findings_states");
var _cloud_posture_page = require("../../components/cloud_posture_page");
var _constants = require("../../common/navigation/constants");
var _latest_findings_container = require("./latest_findings/latest_findings_container");
var _data_view_context = require("../../common/contexts/data_view_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Configurations = () => {
  const location = (0, _reactRouterDom.useLocation)();
  const dataViewQuery = (0, _use_data_view.useDataView)(_cloudSecurityPostureCommon.CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX);
  const {
    data: getSetupStatus,
    isLoading: getSetupStatusIsLoading
  } = (0, _use_csp_setup_status_api.useCspSetupStatusApi)();
  const hasMisconfigurationsFindings = !!(getSetupStatus !== null && getSetupStatus !== void 0 && getSetupStatus.hasMisconfigurationsFindings);
  const hasFindings = hasMisconfigurationsFindings || (getSetupStatus === null || getSetupStatus === void 0 ? void 0 : getSetupStatus.kspm.status) === 'indexed' || (getSetupStatus === null || getSetupStatus === void 0 ? void 0 : getSetupStatus.cspm.status) === 'indexed';

  // For now, when there are no findings we prompt first to install cspm, if it is already installed we will prompt to
  // install kspm
  const noFindingsForPostureType = (getSetupStatus === null || getSetupStatus === void 0 ? void 0 : getSetupStatus.cspm.status) !== 'not-installed' ? 'cspm' : 'kspm';
  if (getSetupStatusIsLoading) return (0, _cloud_posture_page.defaultLoadingRenderer)();
  if (!hasFindings) return /*#__PURE__*/_react.default.createElement(_no_findings_states.NoFindingsStates, {
    postureType: noFindingsForPostureType
  });
  const dataViewContextValue = {
    dataView: dataViewQuery.data,
    dataViewRefetch: dataViewQuery.refetch,
    dataViewIsRefetching: dataViewQuery.isRefetching
  };
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    query: dataViewQuery
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.cloudPosturePages.findings.path,
    render: () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        pathname: _cloudSecurityPosture.findingsNavigation.findings_default.path,
        search: location.search
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _cloudSecurityPosture.findingsNavigation.findings_default.path,
    render: () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
      viewId: _cloudSecurityPosture.findingsNavigation.findings_default.id
    }, /*#__PURE__*/_react.default.createElement(_data_view_context.DataViewContext.Provider, {
      value: dataViewContextValue
    }, /*#__PURE__*/_react.default.createElement(_latest_findings_container.LatestFindingsContainer, null)))
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "*",
    render: () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _cloudSecurityPosture.findingsNavigation.findings_default.path
    })
  })));
};
exports.Configurations = Configurations;