"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnCounterCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VulnCounterCard = ({
  id,
  title,
  titleColor,
  description,
  onClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    onClick: onClick,
    paddingSize: "m",
    css: (0, _react2.css)`
        position: relative;
        display: flex;
        align-items: center;
        :hover .euiIcon {
          color: ${euiTheme.colors.primary};
          transition: ${euiTheme.animation.normal};
        }
      `,
    "data-test-subj": id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    css: {
      height: '100%',
      display: 'flex',
      flexDirection: 'column',
      justifyContent: 'space-around',
      '.euiText h6': {
        textTransform: 'capitalize',
        fontSize: euiTheme.size.m
      }
    },
    titleSize: "s",
    title: title,
    titleColor: titleColor,
    descriptionElement: "h6",
    description: description
  }), onClick && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: 'pivot',
    css: (0, _react2.css)`
            color: ${euiTheme.colors.lightShade};
            position: absolute;
            top: ${euiTheme.size.s};
            right: ${euiTheme.size.s};
          `
  }));
};
exports.VulnCounterCard = VulnCounterCard;