"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CLOUD_DATA_SAVED_OBJECT_TYPE = void 0;
exports.setupSavedObjects = setupSavedObjects;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOUD_DATA_SAVED_OBJECT_TYPE = exports.CLOUD_DATA_SAVED_OBJECT_TYPE = 'cloud';
function setupSavedObjects(savedObjects, logger) {
  savedObjects.registerType({
    name: CLOUD_DATA_SAVED_OBJECT_TYPE,
    hidden: true,
    hiddenFromHttpApis: true,
    namespaceType: 'agnostic',
    mappings: {
      dynamic: false,
      properties: {}
    },
    management: {
      importableAndExportable: false
    },
    modelVersions: {}
  });
}