"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  return (0, _react.useMemo)(() => {
    const panel = {
      position: 'relative'
    };
    const draggable = {
      // setting manually as the spacing of selectors doesn't match with built in sizes
      padding: 0,
      paddingBottom: '12px'
    };
    const hide = {
      display: 'none'
    };
    return {
      panel,
      draggable,
      hide
    };
  }, []);
};
exports.useStyles = useStyles;