"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecuritySolutionLink = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Gets the cloud_defend link properties of a Cloud Defend page for navigation in the security solution.
 * @param cloudDefendPage the name of the cloud defend page.
 */
const getSecuritySolutionLink = cloudDefendPage => {
  return {
    id: _constants.cloudDefendPages[cloudDefendPage].id,
    title: _constants.cloudDefendPages[cloudDefendPage].name,
    path: _constants.cloudDefendPages[cloudDefendPage].path
  };
};
exports.getSecuritySolutionLink = getSecuritySolutionLink;