"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.casesSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserSchema = _configSchema.schema.object({
  email: _configSchema.schema.nullable(_configSchema.schema.string()),
  full_name: _configSchema.schema.nullable(_configSchema.schema.string()),
  username: _configSchema.schema.nullable(_configSchema.schema.string()),
  profile_uid: _configSchema.schema.nullable(_configSchema.schema.string())
});
const UserProfileSchema = _configSchema.schema.object({
  uid: _configSchema.schema.string()
});
const ConnectorSchema = _configSchema.schema.object({
  name: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  fields: _configSchema.schema.arrayOf(_configSchema.schema.object({
    key: _configSchema.schema.string(),
    value: _configSchema.schema.string()
  }))
});
const ExternalServiceSchema = _configSchema.schema.object({
  connector_name: _configSchema.schema.string(),
  external_id: _configSchema.schema.string(),
  external_title: _configSchema.schema.string(),
  external_url: _configSchema.schema.string(),
  pushed_at: _configSchema.schema.string(),
  pushed_by: UserSchema
});
const SettingsSchema = _configSchema.schema.object({
  syncAlerts: _configSchema.schema.boolean()
});
const CustomFieldsSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  key: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  value: _configSchema.schema.nullable(_configSchema.schema.any())
}));
const casesSchema = exports.casesSchema = _configSchema.schema.object({
  assignees: _configSchema.schema.arrayOf(UserProfileSchema),
  category: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  closed_at: _configSchema.schema.nullable(_configSchema.schema.string()),
  closed_by: _configSchema.schema.nullable(UserSchema),
  created_at: _configSchema.schema.string(),
  created_by: UserSchema,
  connector: ConnectorSchema,
  customFields: _configSchema.schema.maybe(_configSchema.schema.nullable(CustomFieldsSchema)),
  description: _configSchema.schema.string(),
  duration: _configSchema.schema.nullable(_configSchema.schema.number()),
  external_service: _configSchema.schema.nullable(ExternalServiceSchema),
  owner: _configSchema.schema.string(),
  settings: SettingsSchema,
  severity: _configSchema.schema.oneOf([_configSchema.schema.literal(10), _configSchema.schema.literal(20), _configSchema.schema.literal(30), _configSchema.schema.literal(40)]),
  status: _configSchema.schema.oneOf([_configSchema.schema.literal(0), _configSchema.schema.literal(10), _configSchema.schema.literal(20)]),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  title: _configSchema.schema.string(),
  total_alerts: _configSchema.schema.number(),
  total_comments: _configSchema.schema.number(),
  updated_at: _configSchema.schema.nullable(_configSchema.schema.string()),
  updated_by: _configSchema.schema.nullable(UserSchema)
});