"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Username = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _display_name = require("./display_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UsernameComponent = ({
  userInfo,
  boldName = false
}) => {
  const name = (0, _display_name.getName)(userInfo === null || userInfo === void 0 ? void 0 : userInfo.user);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "eui-textBreakWord",
    "data-test-subj": "user-profile-username"
  }, boldName ? /*#__PURE__*/_react.default.createElement("strong", {
    "data-test-subj": 'user-profile-username-bolded'
  }, name) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, name));
};
UsernameComponent.displayName = 'Username';
const Username = exports.Username = /*#__PURE__*/_react.default.memo(UsernameComponent);