"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLicenseError = exports.getKibanaConfigError = exports.getDeletedConnectorError = exports.getConnectorMissingInfo = exports.getCaseClosedInfo = exports.getActionLicenseError = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("./callout/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLicenseError = () => ({
  id: 'license-error',
  title: '',
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Opening cases in external systems is available when you have the {appropriateLicense}, are using a {cloud}, or are testing out a Free Trial.",
    id: "xpack.cases.caseView.pushToServiceDisableByLicenseDescription",
    values: {
      appropriateLicense: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/subscriptions",
        target: "_blank"
      }, i18n.LINK_APPROPRIATE_LICENSE),
      cloud: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/cloud/elasticsearch-service/signup",
        target: "_blank"
      }, i18n.LINK_CLOUD_DEPLOYMENT)
    }
  })
});
exports.getLicenseError = getLicenseError;
const getKibanaConfigError = () => ({
  id: 'kibana-config-error',
  title: i18n.PUSH_DISABLE_BY_KIBANA_CONFIG_TITLE,
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The kibana.yml file is configured to only allow specific connectors. To enable opening a case in external systems, add .[actionTypeId] (ex: .servicenow | .jira) to the xpack.actions.enabledActiontypes setting. For more information, see {link}.",
    id: "xpack.cases.caseView.pushToServiceDisableByConfigDescription",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/kibana/current/alert-action-settings-kb.html",
        target: "_blank"
      }, i18n.LINK_ACTIONS_CONFIGURATION)
    }
  })
});
exports.getKibanaConfigError = getKibanaConfigError;
const getActionLicenseError = actionLicense => {
  let errors = [];
  if (actionLicense != null && !actionLicense.enabledInLicense) {
    errors = [...errors, getLicenseError()];
  }
  if (actionLicense != null && !actionLicense.enabledInConfig) {
    errors = [...errors, getKibanaConfigError()];
  }
  return errors;
};
exports.getActionLicenseError = getActionLicenseError;
const getConnectorMissingInfo = () => ({
  id: 'connector-missing-error',
  title: '',
  description: i18n.CONFIGURE_CONNECTOR
});
exports.getConnectorMissingInfo = getConnectorMissingInfo;
const getDeletedConnectorError = () => ({
  id: 'connector-deleted-error',
  title: '',
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The connector used to send updates to the external service has been deleted or you do not have the {appropriateLicense} to use it. To update cases in external systems, select a different connector or create a new one.",
    id: "xpack.cases.configureCases.warningMessage",
    values: {
      appropriateLicense: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/subscriptions",
        target: "_blank"
      }, i18n.LINK_APPROPRIATE_LICENSE)
    }
  }),
  errorType: 'danger'
});
exports.getDeletedConnectorError = getDeletedConnectorError;
const getCaseClosedInfo = () => ({
  id: _types.CLOSED_CASE_PUSH_ERROR_ID,
  title: '',
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Closed cases cannot be sent to external systems. Reopen the case if you want to open or update it in an external system.",
    id: "xpack.cases.caseView.pushToServiceDisableBecauseCaseClosedDescription"
  })
});
exports.getCaseClosedInfo = getCaseClosedInfo;