"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TruncatedText = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LINE_CLAMP = 3;
const getTextCss = (0, _react2.css)`
  text-overflow: ellipsis;
  display: -webkit-box;
  -webkit-line-clamp: ${LINE_CLAMP};
  -webkit-box-orient: vertical;
  overflow: hidden;
  word-break: break-word;
`;
const TruncatedTextComponent = ({
  text
}) => {
  return /*#__PURE__*/_react.default.createElement("span", {
    css: getTextCss,
    title: text
  }, text);
};
TruncatedTextComponent.displayName = 'TruncatedText';
const TruncatedText = exports.TruncatedText = /*#__PURE__*/_react.default.memo(TruncatedTextComponent);