"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoCases = void 0;
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("../translations"));
var _links = require("../../links");
var _use_cases_context = require("../../cases_context/use_cases_context");
var _navigation = require("../../../common/navigation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoCasesComponent = ({
  recentCasesFilterBy
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    getCreateCaseUrl,
    navigateToCreateCase
  } = (0, _navigation.useCreateCaseNavigation)();
  const navigateToCreateCaseClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    navigateToCreateCase();
  }, [navigateToCreateCase]);
  const getNoCasesMessage = () => {
    if (recentCasesFilterBy === 'myRecentlyAssigned') {
      return /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "no-cases-assigned-to-me"
      }, i18n.NO_CASES_ASSIGNED_TO_ME);
    }
    return permissions.create ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", null, i18n.NO_CASES), /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
      "data-test-subj": "no-cases-create-case",
      onClick: navigateToCreateCaseClick,
      href: getCreateCaseUrl()
    }, ` ${i18n.START_A_NEW_CASE}`), '!') : /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "no-cases-readonly"
    }, i18n.NO_CASES_READ_ONLY);
  };
  return getNoCasesMessage();
};
NoCasesComponent.displayName = 'NoCasesComponent';
const NoCases = exports.NoCases = /*#__PURE__*/_react.default.memo(NoCasesComponent);