"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PropertyActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../../client/attachment_framework/types");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ComponentId = 'property-actions';
const PropertyActionButton = /*#__PURE__*/_react.default.memo(({
  disabled = false,
  onClick,
  iconType,
  label,
  color,
  customDataTestSubj
}) => {
  const dataTestSubjPrepend = makeDataTestSubjPrepend(customDataTestSubj);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": label,
    color: color ? color : 'text',
    "data-test-subj": `${dataTestSubjPrepend}-${iconType}`,
    iconSide: "left",
    iconType: iconType,
    isDisabled: disabled,
    onClick: onClick
  }, label);
});
PropertyActionButton.displayName = 'PropertyActionButton';
const PropertyActions = exports.PropertyActions = /*#__PURE__*/_react.default.memo(({
  propertyActions,
  customDataTestSubj
}) => {
  const [showActions, setShowActions] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setShowActions(prevShowActions => !prevShowActions);
  }, []);
  const onClosePopover = (0, _react.useCallback)(cb => {
    setShowActions(false);
    if (cb != null) {
      cb();
    }
  }, []);
  const dataTestSubjPrepend = makeDataTestSubjPrepend(customDataTestSubj);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    "data-test-subj": dataTestSubjPrepend,
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": `${dataTestSubjPrepend}-ellipses`,
      "aria-label": i18n.ACTIONS_ARIA,
      iconType: "boxesHorizontal",
      onClick: onButtonClick
    }),
    id: "settingsPopover",
    isOpen: showActions,
    closePopover: onClosePopover,
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    "data-test-subj": `${dataTestSubjPrepend}-group`,
    direction: "column",
    gutterSize: "none"
  }, propertyActions.map((action, key) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: `${action.type}-${key}`
  }, /*#__PURE__*/_react.default.createElement("span", null, action.type === _types.AttachmentActionType.BUTTON && /*#__PURE__*/_react.default.createElement(PropertyActionButton, {
    disabled: action.disabled,
    iconType: action.iconType,
    label: action.label,
    color: action.color,
    onClick: () => onClosePopover(action.onClick),
    customDataTestSubj: customDataTestSubj
  }) || action.type === _types.AttachmentActionType.CUSTOM && /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, action.render()))))));
});
PropertyActions.displayName = 'PropertyActions';
const makeDataTestSubjPrepend = customDataTestSubj => {
  return customDataTestSubj == null ? ComponentId : `${ComponentId}-${customDataTestSubj}`;
};