"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormFieldsComponent = ({
  isSubmitting
}) => {
  const labelFieldProps = (0, _react.useMemo)(() => ({
    euiFieldProps: {
      'data-test-subj': 'observable-type-label-input',
      fullWidth: true,
      autoFocus: true,
      isLoading: isSubmitting
    }
  }), [isSubmitting]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "key",
    component: _components.HiddenField
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "label",
    component: _components.TextField,
    componentProps: labelFieldProps
  }));
};
FormFieldsComponent.displayName = 'FormFields';
const FormFields = exports.FormFields = /*#__PURE__*/(0, _react.memo)(FormFieldsComponent);