"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEuiTableColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEuiTableColumn = ({
  label
}) => ({
  name: label,
  width: '100px',
  render: customField => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "data-test-subj": `toggle-custom-field-column-view-${customField.key}-${customField !== null && customField !== void 0 && customField.value ? 'check' : 'cross'}`,
    type: customField !== null && customField !== void 0 && customField.value ? 'check' : 'cross'
  }),
  'data-test-subj': 'toggle-custom-field-column'
});
exports.getEuiTableColumn = getEuiTableColumn;