"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCaseOwnerSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseOwnerSelector = ({
  availableOwners,
  isLoading,
  onOwnerChange,
  selectedOwner
}) => {
  const onChange = owner => {
    onOwnerChange(owner);
  };
  const options = Object.entries(_constants.OWNER_INFO).filter(([owner]) => availableOwners.includes(owner)).map(([owner, definition]) => ({
    value: owner,
    inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: definition.iconType,
      size: "m",
      title: definition.label,
      className: "eui-alignMiddle"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("small", null, definition.label))),
    'data-test-subj': `${definition.id}OwnerOption`
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: i18n.SOLUTION_SELECTOR_LABEL,
    "data-test-subj": "caseOwnerSelector",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "caseOwnerSuperSelect",
    options: options,
    isLoading: isLoading,
    fullWidth: true,
    valueOfSelected: selectedOwner,
    onChange: owner => onChange(owner),
    compressed: true
  }));
};
CaseOwnerSelector.displayName = 'CaseOwnerSelectionComponent';
const CreateCaseOwnerSelector = exports.CreateCaseOwnerSelector = /*#__PURE__*/(0, _react.memo)(CaseOwnerSelector);