"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesAddToNewCaseFlyout = void 0;
var _react = require("react");
var _use_cases_toast = require("../../../common/use_cases_toast");
var _cases_context_reducer = require("../../cases_context/state/cases_context_reducer");
var _use_cases_context = require("../../cases_context/use_cases_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCasesAddToNewCaseFlyout = ({
  initialValue,
  toastTitle,
  toastContent,
  afterCaseCreated,
  onSuccess,
  onClose
} = {}) => {
  const {
    dispatch
  } = (0, _use_cases_context.useCasesContext)();
  const casesToasts = (0, _use_cases_toast.useCasesToast)();
  const closeFlyout = (0, _react.useCallback)(() => {
    dispatch({
      type: _cases_context_reducer.CasesContextStoreActionsList.CLOSE_CREATE_CASE_FLYOUT
    });
  }, [dispatch]);
  const openFlyout = (0, _react.useCallback)(({
    attachments,
    headerContent
  } = {}) => {
    dispatch({
      type: _cases_context_reducer.CasesContextStoreActionsList.OPEN_CREATE_CASE_FLYOUT,
      payload: {
        initialValue,
        attachments,
        headerContent,
        onClose: () => {
          closeFlyout();
          if (onClose) {
            return onClose();
          }
        },
        onSuccess: async theCase => {
          if (theCase) {
            casesToasts.showSuccessAttach({
              theCase,
              attachments: attachments !== null && attachments !== void 0 ? attachments : [],
              title: toastTitle,
              content: toastContent
            });
          }
          if (onSuccess) {
            return onSuccess(theCase);
          }
        },
        afterCaseCreated: async (...args) => {
          closeFlyout();
          if (afterCaseCreated) {
            return afterCaseCreated(...args);
          }
        }
      }
    });
  }, [initialValue, casesToasts, closeFlyout, dispatch, toastTitle, toastContent, afterCaseCreated, onSuccess, onClose]);
  return (0, _react.useMemo)(() => {
    return {
      open: openFlyout,
      close: closeFlyout
    };
  }, [openFlyout, closeFlyout]);
};
exports.useCasesAddToNewCaseFlyout = useCasesAddToNewCaseFlyout;