"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InteractiveWorkpadPage = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _element_wrapper = require("../../element_wrapper");
var _layout_annotations = require("../../layout_annotations");
var _workpad_shortcuts = require("../../workpad_shortcuts");
var _prop_types = require("../prop_types");
var _interaction_boundary = require("./interaction_boundary");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InteractiveWorkpadPage extends _react.PureComponent {
  componentWillUnmount() {
    this.props.resetHandler();
  }
  render() {
    const {
      pageId,
      pageStyle,
      className,
      elements,
      cursor = 'auto',
      height,
      width,
      onDoubleClick,
      onKeyDown,
      onMouseDown,
      onMouseLeave,
      onMouseMove,
      onMouseUp,
      onAnimationEnd,
      onWheel,
      selectedNodes,
      selectToplevelNodes,
      insertNodes,
      removeNodes,
      elementLayer,
      canvasOrigin,
      saveCanvasOrigin,
      commit,
      setMultiplePositions,
      zoomScale
    } = this.props;
    let shortcuts = null;
    const shortcutProps = {
      elementLayer,
      insertNodes,
      pageId,
      removeNodes,
      selectedNodes,
      selectToplevelNodes,
      commit,
      setMultiplePositions
    };
    shortcuts = /*#__PURE__*/_react.default.createElement(_workpad_shortcuts.WorkpadShortcuts, shortcutProps);
    return /*#__PURE__*/_react.default.createElement("div", {
      key: pageId,
      id: pageId,
      ref: node => {
        if (!canvasOrigin && node && node.getBoundingClientRect) {
          saveCanvasOrigin(() => () => node.getBoundingClientRect());
        }
      },
      "data-test-subj": "canvasWorkpadPage",
      className: `canvasPage kbn-resetFocusState canvasInteractivePage ${className}`,
      "data-shared-items-container": true,
      style: {
        ...pageStyle,
        height,
        width,
        cursor
      },
      onKeyDown: onKeyDown,
      onMouseMove: onMouseMove,
      onMouseUp: onMouseUp,
      onMouseDown: onMouseDown,
      onMouseLeave: onMouseLeave,
      onDoubleClick: onDoubleClick,
      onAnimationEnd: onAnimationEnd,
      onWheel: onWheel
    }, /*#__PURE__*/_react.default.createElement(_interaction_boundary.InteractionBoundary, null), shortcuts, elements.map(node => {
      if (node.type === 'annotation') {
        const props = {
          key: node.id,
          type: node.type,
          transformMatrix: node.transformMatrix,
          width: node.width,
          height: node.height,
          text: node.text,
          zoomScale
        };
        switch (node.subtype) {
          case 'alignmentGuide':
            return /*#__PURE__*/_react.default.createElement(_layout_annotations.AlignmentGuide, props);
          case 'adHocChildAnnotation': // now sharing aesthetics but may diverge in the future
          case 'hoverAnnotation':
            // fixme: with the upcoming TS work, use enumerative types here
            return /*#__PURE__*/_react.default.createElement(_layout_annotations.HoverAnnotation, props);
          case 'dragBoxAnnotation':
            return /*#__PURE__*/_react.default.createElement(_layout_annotations.DragBoxAnnotation, props);
          case 'rotationHandle':
            return /*#__PURE__*/_react.default.createElement(_layout_annotations.RotationHandle, props);
          case 'resizeHandle':
            return /*#__PURE__*/_react.default.createElement(_layout_annotations.BorderResizeHandle, props);
          case 'resizeConnector':
            return /*#__PURE__*/_react.default.createElement(_layout_annotations.BorderConnection, props);
          case 'rotationTooltip':
            return /*#__PURE__*/_react.default.createElement(_layout_annotations.TooltipAnnotation, props);
          default:
            return [];
        }
      } else if (node.type !== 'group') {
        return /*#__PURE__*/_react.default.createElement(_element_wrapper.ElementWrapper, {
          key: node.id,
          element: node
        });
      }
    }).filter(element => !!element));
  }
}
exports.InteractiveWorkpadPage = InteractiveWorkpadPage;
(0, _defineProperty2.default)(InteractiveWorkpadPage, "propTypes", _prop_types.interactiveWorkpadPagePropTypes);