"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasourceSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatasourceSelector = ({
  onSelect,
  datasources,
  current
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasDataSource__list"
}, datasources.map(d => /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
  key: d.name,
  title: d.displayName,
  titleElement: "h5",
  titleSize: "xs",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: d.image,
    size: "l"
  }),
  description: d.help,
  layout: "horizontal",
  className: "canvasDataSource__card",
  selectable: {
    isSelected: d.name === current ? true : false,
    onClick: () => onSelect(d.name)
  },
  "data-test-subj": `canvasDatasourceCard__${d.name}`
})));
exports.DatasourceSelector = DatasourceSelector;
DatasourceSelector.propTypes = {
  onSelect: _propTypes.default.func.isRequired,
  datasources: _propTypes.default.array.isRequired,
  current: _propTypes.default.string.isRequired
};