"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMobileHttpErrors = getMobileHttpErrors;
var _common = require("@kbn/observability-plugin/common");
var _server = require("@kbn/observability-plugin/server");
var _get_offset_in_ms = require("../../../../common/utils/get_offset_in_ms");
var _environment_query = require("../../../../common/utils/environment_query");
var _apm = require("../../../../common/es_fields/apm");
var _offset_previous_period_coordinate = require("../../../../common/utils/offset_previous_period_coordinate");
var _constants = require("../../transactions/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getBucketSize({
  start,
  end
}) {
  return Math.floor((end - start) / _constants.BUCKET_TARGET_COUNT);
}
async function getMobileHttpErrorsTimeseries({
  kuery,
  apmEventClient,
  serviceName,
  environment,
  start,
  end
}) {
  var _response$aggregation;
  const bucketSize = getBucketSize({
    start,
    end
  });
  const response = await apmEventClient.search('get_mobile_http_errors', {
    apm: {
      events: [_common.ProcessorEvent.error]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.rangeQuery)(start, end), ...(0, _server.rangeQuery)(400, 599, _apm.HTTP_RESPONSE_STATUS_CODE), ...(0, _server.kqlQuery)(kuery)],
          must_not: {
            term: {
              'error.type': 'crash'
            }
          }
        }
      },
      aggs: {
        timeseries: {
          histogram: {
            field: '@timestamp',
            min_doc_count: 0,
            interval: bucketSize,
            extended_bounds: {
              min: start,
              max: end
            }
          }
        }
      }
    }
  });
  const timeseries = ((response === null || response === void 0 ? void 0 : (_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : _response$aggregation.timeseries.buckets) || []).map(bucket => ({
    x: bucket.key,
    y: bucket.doc_count
  }));
  return {
    timeseries
  };
}
async function getMobileHttpErrors({
  kuery,
  apmEventClient,
  serviceName,
  environment,
  start,
  end,
  offset
}) {
  const options = {
    serviceName,
    apmEventClient,
    kuery,
    environment
  };
  const {
    startWithOffset,
    endWithOffset
  } = (0, _get_offset_in_ms.getOffsetInMs)({
    start,
    end,
    offset
  });
  const currentPeriodPromise = getMobileHttpErrorsTimeseries({
    ...options,
    start,
    end
  });
  const previousPeriodPromise = offset ? getMobileHttpErrorsTimeseries({
    ...options,
    start: startWithOffset,
    end: endWithOffset
  }) : {
    timeseries: []
  };
  const [currentPeriod, previousPeriod] = await Promise.all([currentPeriodPromise, previousPeriodPromise]);
  return {
    currentPeriod,
    previousPeriod: {
      timeseries: (0, _offset_previous_period_coordinate.offsetPreviousPeriodCoordinates)({
        currentPeriodTimeseries: currentPeriod.timeseries,
        previousPeriodTimeseries: previousPeriod.timeseries
      })
    }
  };
}