"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasUnsetValueForField = hasUnsetValueForField;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../common/es_fields/apm");
var _transactions = require("../../lib/helpers/transactions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is used for getting the list of environments for the environment selector,
 * filtered by range.
 */

async function hasUnsetValueForField({
  searchAggregatedTransactions,
  apmEventClient,
  serviceName,
  fieldName,
  start,
  end
}) {
  var _resp$hits$total;
  const params = {
    apm: {
      events: [(0, _transactions.getProcessorEventForTransactions)(searchAggregatedTransactions), _common.ProcessorEvent.metric, _common.ProcessorEvent.error]
    },
    body: {
      track_total_hits: true,
      terminate_after: 1,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _server.rangeQuery)(start, end), ...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName)],
          must_not: [{
            exists: {
              field: fieldName
            }
          }]
        }
      }
    }
  };
  const resp = await apmEventClient.search('has_unset_value_for_field', params);
  return ((_resp$hits$total = resp.hits.total) === null || _resp$hits$total === void 0 ? void 0 : _resp$hits$total.value) > 0;
}