"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiagnosticsBundle = getDiagnosticsBundle;
var _i18n = require("../../../common/i18n");
var _get_data_streams = require("./bundle/get_data_streams");
var _get_non_data_stream_indices = require("./bundle/get_non_data_stream_indices");
var _get_elasticsearch_version = require("./get_elasticsearch_version");
var _get_index_templates_by_index_pattern = require("./bundle/get_index_templates_by_index_pattern");
var _get_existing_index_templates = require("./bundle/get_existing_index_templates");
var _get_indices_states = require("./bundle/get_indices_states");
var _get_apm_events = require("./bundle/get_apm_events");
var _get_apm_index_template_names = require("./helpers/get_apm_index_template_names");
var _handle_exceptions = require("./helpers/handle_exceptions");
var _get_diagnostic_privileges = require("./helpers/get_diagnostic_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFEAULT_START = Date.now() - 60 * 5 * 1000; // 5 minutes
const DEFAULT_END = Date.now();
async function getDiagnosticsBundle({
  esClient,
  apmIndices,
  start = DEFEAULT_START,
  end = DEFAULT_END,
  kuery
}) {
  var _await$handleExceptio, _await$handleExceptio2, _await$handleExceptio3, _await$handleExceptio4, _await$handleExceptio5, _await$handleExceptio6, _await$handleExceptio7;
  const diagnosticsPrivileges = await (0, _get_diagnostic_privileges.getDiagnosticsPrivileges)({
    esClient,
    apmIndices
  });
  const indexTemplatesByIndexPattern = (_await$handleExceptio = await (0, _handle_exceptions.handleExceptions)((0, _get_index_templates_by_index_pattern.getIndexTemplatesByIndexPattern)({
    esClient,
    apmIndices
  }))) !== null && _await$handleExceptio !== void 0 ? _await$handleExceptio : [];
  const existingIndexTemplates = (_await$handleExceptio2 = await (0, _handle_exceptions.handleExceptions)((0, _get_existing_index_templates.getExistingApmIndexTemplates)({
    esClient
  }))) !== null && _await$handleExceptio2 !== void 0 ? _await$handleExceptio2 : [];
  const dataStreams = (_await$handleExceptio3 = await (0, _handle_exceptions.handleExceptions)((0, _get_data_streams.getDataStreams)({
    esClient,
    apmIndices
  }))) !== null && _await$handleExceptio3 !== void 0 ? _await$handleExceptio3 : [];
  const nonDataStreamIndices = (_await$handleExceptio4 = await (0, _handle_exceptions.handleExceptions)((0, _get_non_data_stream_indices.getNonDataStreamIndices)({
    esClient,
    apmIndices
  }))) !== null && _await$handleExceptio4 !== void 0 ? _await$handleExceptio4 : [];
  const {
    invalidIndices,
    validIndices,
    indices,
    ingestPipelines,
    fieldCaps
  } = (_await$handleExceptio5 = await (0, _handle_exceptions.handleExceptions)((0, _get_indices_states.getIndicesStates)({
    esClient,
    apmIndices
  }))) !== null && _await$handleExceptio5 !== void 0 ? _await$handleExceptio5 : {};
  const apmEvents = (_await$handleExceptio6 = await (0, _handle_exceptions.handleExceptions)((0, _get_apm_events.getApmEvents)({
    esClient,
    apmIndices,
    start,
    end,
    kuery
  }))) !== null && _await$handleExceptio6 !== void 0 ? _await$handleExceptio6 : [];
  const elasticsearchVersion = (_await$handleExceptio7 = await (0, _handle_exceptions.handleExceptions)((0, _get_elasticsearch_version.getElasticsearchVersion)(esClient))) !== null && _await$handleExceptio7 !== void 0 ? _await$handleExceptio7 : _i18n.NOT_AVAILABLE_LABEL;
  return {
    created_at: new Date().toISOString(),
    diagnosticsPrivileges,
    apmIndices,
    elasticsearchVersion,
    esResponses: {
      fieldCaps,
      indices,
      ingestPipelines,
      existingIndexTemplates
    },
    apmIndexTemplates: (0, _get_apm_index_template_names.getApmIndexTemplates)(existingIndexTemplates),
    invalidIndices,
    validIndices,
    indexTemplatesByIndexPattern,
    dataStreams,
    nonDataStreamIndices,
    apmEvents,
    params: {
      start,
      end,
      kuery
    }
  };
}