"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentMarker = AgentMarker;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _formatters = require("../../../../../../common/utils/formatters");
var _use_theme = require("../../../../../hooks/use_theme");
var _legend = require("../legend");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NameContainer = _common.euiStyled.div`
  border-bottom: 1px solid ${({
  theme
}) => theme.eui.euiColorMediumShade};
  padding-bottom: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const TimeContainer = _common.euiStyled.div`
  color: ${({
  theme
}) => theme.eui.euiColorMediumShade};
  padding-top: ${({
  theme
}) => theme.eui.euiSizeS};
`;
function AgentMarker({
  mark
}) {
  const theme = (0, _use_theme.useTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    id: mark.id,
    position: "top",
    content: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(NameContainer, null, mark.id), /*#__PURE__*/_react.default.createElement(TimeContainer, null, (0, _formatters.asDuration)(mark.offset)))
  }, /*#__PURE__*/_react.default.createElement(_legend.Legend, {
    clickable: true,
    color: theme.eui.euiColorMediumShade
  })));
}