"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectWithDefaultEnvironment = RedirectWithDefaultEnvironment;
var _reactRouterDom = require("react-router-dom");
var _queryString = _interopRequireDefault(require("query-string"));
var _react = _interopRequireDefault(require("react"));
var _use_default_environment = require("../../../../hooks/use_default_environment");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RedirectWithDefaultEnvironment({
  children
}) {
  const location = (0, _reactRouterDom.useLocation)();
  const query = _queryString.default.parse(location.search);
  const defaultServiceEnvironment = (0, _use_default_environment.useDefaultEnvironment)();
  if ('environment' in query) {
    return children;
  }
  const normalizedPathname = location.pathname.replace(/\/$/, '');
  if (normalizedPathname === '/services') {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _queryString.default.stringifyUrl({
        url: location.pathname,
        query: {
          ...query,
          environment: defaultServiceEnvironment
        }
      })
    });
  }
  return children;
}