"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaOverview = SchemaOverview;
exports.SchemaOverviewHeading = SchemaOverviewHeading;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _blog_rocket_720x = _interopRequireDefault(require("./blog_rocket_720x420.png"));
var _migration_in_progress_panel = require("./migration_in_progress_panel");
var _upgrade_available_card = require("./migrated/upgrade_available_card");
var _successful_migration_card = require("./migrated/successful_migration_card");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SchemaOverview({
  onSwitch,
  isMigrating,
  isMigrated,
  isLoading,
  isLoadingConfirmation,
  cloudApmMigrationEnabled,
  hasCloudAgentPolicy,
  hasRequiredRole,
  cloudApmPackagePolicy,
  latestApmPackageVersion
}) {
  var _cloudApmPackagePolic;
  const isDisabled = !cloudApmMigrationEnabled || !hasCloudAgentPolicy || !hasRequiredRole;
  const packageVersion = cloudApmPackagePolicy === null || cloudApmPackagePolicy === void 0 ? void 0 : (_cloudApmPackagePolic = cloudApmPackagePolicy.package) === null || _cloudApmPackagePolic === void 0 ? void 0 : _cloudApmPackagePolic.version;
  const isUpgradeAvailable = packageVersion && (0, _lt.default)(packageVersion, latestApmPackageVersion);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SchemaOverviewHeading, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    })));
  }
  if (isMigrating && !isMigrated) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SchemaOverviewHeading, null), /*#__PURE__*/_react.default.createElement(_migration_in_progress_panel.MigrationInProgressPanel, null));
  }
  if (isMigrated) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SchemaOverviewHeading, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 2
    }, isUpgradeAvailable ? /*#__PURE__*/_react.default.createElement(_upgrade_available_card.UpgradeAvailableCard, {
      apmPackagePolicyId: cloudApmPackagePolicy === null || cloudApmPackagePolicy === void 0 ? void 0 : cloudApmPackagePolicy.id
    }) : /*#__PURE__*/_react.default.createElement(_successful_migration_card.SuccessfulMigrationCard, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null)));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SchemaOverviewHeading, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: '250px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "node"
    }),
    title: _i18n.i18n.translate('xpack.apm.settings.schema.migrate.classicIndices.title', {
      defaultMessage: 'APM Server binary'
    }),
    display: "subdued",
    description: _i18n.i18n.translate('xpack.apm.settings.schema.migrate.classicIndices.description', {
      defaultMessage: 'You are currently using APM Server binary. This legacy option is deprecated since version 7.16 and is being replaced by a managed APM Server in Elastic Agent from version 8.0.'
    }),
    footer: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.settings.schema.migrate.classicIndices.currentSetup', {
      defaultMessage: 'Current setup'
    }))))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: '250px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    image: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("img", {
      src: _blog_rocket_720x.default,
      alt: "rocket launch"
    })),
    title: _i18n.i18n.translate('xpack.apm.settings.schema.migrate.dataStreams.title', {
      defaultMessage: 'Elastic Agent'
    }),
    description: _i18n.i18n.translate('xpack.apm.settings.schema.migrate.dataStreams.description', {
      defaultMessage: 'Starting in version 8.0, APM Server is recommended to be managed by Elastic Agent. Elastic Agent can run on our hosted Elasticsearch Service, ECE, or be self-managed. Then, add the Elastic APM integration to continue ingesting APM data.'
    }),
    footer: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: getDisabledReason({
        cloudApmMigrationEnabled,
        hasCloudAgentPolicy,
        hasRequiredRole
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmSchemaOverviewSwitchToElasticAgentButton",
      fill: true,
      isLoading: isLoadingConfirmation,
      isDisabled: isDisabled
    }, _i18n.i18n.translate('xpack.apm.settings.schema.migrate.dataStreams.buttonText', {
      defaultMessage: 'Switch to Elastic Agent'
    })))),
    onClick: onSwitch,
    isDisabled: isDisabled
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null)));
}
function SchemaOverviewHeading() {
  const {
    docLinks
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.settings.schema.descriptionText",
    defaultMessage: "We have created a simple and seamless process for switching from APM Server binary to Elastic Agent. Beware this action is {irreversibleEmphasis} and can only be performed by a {superuserEmphasis} with access to Fleet. Learn more about {elasticAgentDocLink}.",
    values: {
      irreversibleEmphasis: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.apm.settings.schema.descriptionText.irreversibleEmphasisText', {
        defaultMessage: 'irreversible'
      })),
      superuserEmphasis: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.apm.settings.schema.descriptionText.superuserEmphasisText', {
        defaultMessage: 'superuser'
      })),
      elasticAgentDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmSchemaOverviewHeadingElasticAgentLink",
        target: "_blank",
        href: docLinks.links.apm.elasticAgent
      }, _i18n.i18n.translate('xpack.apm.settings.schema.descriptionText.elasticAgentDocLinkText', {
        defaultMessage: 'Elastic Agent'
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
}
function getDisabledReason({
  cloudApmMigrationEnabled,
  hasCloudAgentPolicy,
  hasRequiredRole
}) {
  const reasons = [];
  if (!cloudApmMigrationEnabled) {
    reasons.push(_i18n.i18n.translate('xpack.apm.settings.schema.disabledReason.cloudApmMigrationEnabled', {
      defaultMessage: 'Cloud migration is not enabled'
    }));
  }
  if (hasRequiredRole && !hasCloudAgentPolicy) {
    reasons.push(_i18n.i18n.translate('xpack.apm.settings.schema.disabledReason.hasCloudAgentPolicy', {
      defaultMessage: 'Cloud agent policy does not exist'
    }));
  }
  if (!hasRequiredRole) {
    reasons.push(_i18n.i18n.translate('xpack.apm.settings.schema.disabledReason.hasRequiredRole', {
      defaultMessage: 'User does not have superuser role'
    }));
  }
  if (reasons.length) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.settings.schema.disabledReason",
      defaultMessage: "Switch to Elastic Agent is unavailable: {reasons}",
      values: {
        reasons: /*#__PURE__*/_react.default.createElement("ul", null, reasons.map((reasonText, index) => /*#__PURE__*/_react.default.createElement("li", {
          key: index
        }, "- ", reasonText)))
      }
    });
  }
}