"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AAD_INDEX_PATTERN = void 0;
exports.getTotalAlertsCountAggregations = getTotalAlertsCountAggregations;
var _alerting_usage_collector = require("../alerting_usage_collector");
var _parse_count_ignored_rule_type_bucket = require("./parse_count_ignored_rule_type_bucket");
var _parse_simple_rule_type_bucket = require("./parse_simple_rule_type_bucket");
var _parse_and_log_error = require("./parse_and_log_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AAD_INDEX_PATTERN = exports.AAD_INDEX_PATTERN = '.alerts-*';
async function getTotalAlertsCountAggregations({
  esClient,
  logger
}) {
  try {
    var _results$hits$total, _aggregations$by_rule, _aggregations$by_rule2;
    const query = {
      index: AAD_INDEX_PATTERN,
      size: 0,
      body: {
        query: {
          match_all: {}
        },
        aggs: {
          by_rule_type_id: {
            terms: {
              field: 'kibana.alert.rule.rule_type_id',
              size: _alerting_usage_collector.NUM_ALERTING_RULE_TYPES
            },
            aggs: {
              ignored_field: {
                terms: {
                  field: '_ignored',
                  size: _alerting_usage_collector.NUM_ALERTING_RULE_TYPES
                }
              }
            }
          }
        }
      }
    };
    logger.debug(() => `query for getTotalAlertsCountAggregations - ${JSON.stringify(query)}`);
    const results = await esClient.search(query);
    logger.debug(() => `results for getTotalAlertsCountAggregations query - ${JSON.stringify(results)}`);
    const totalAlertsCount = typeof results.hits.total === 'number' ? results.hits.total : (_results$hits$total = results.hits.total) === null || _results$hits$total === void 0 ? void 0 : _results$hits$total.value;
    const aggregations = results.aggregations;
    return {
      hasErrors: false,
      count_alerts_total: totalAlertsCount !== null && totalAlertsCount !== void 0 ? totalAlertsCount : 0,
      count_alerts_by_rule_type: (0, _parse_simple_rule_type_bucket.parseSimpleRuleTypeBucket)(aggregations === null || aggregations === void 0 ? void 0 : (_aggregations$by_rule = aggregations.by_rule_type_id) === null || _aggregations$by_rule === void 0 ? void 0 : _aggregations$by_rule.buckets),
      count_ignored_fields_by_rule_type: (0, _parse_count_ignored_rule_type_bucket.parseCountIgnoreRuleTypeBucket)(aggregations === null || aggregations === void 0 ? void 0 : (_aggregations$by_rule2 = aggregations.by_rule_type_id) === null || _aggregations$by_rule2 === void 0 ? void 0 : _aggregations$by_rule2.buckets)
    };
  } catch (err) {
    const errorMessage = (0, _parse_and_log_error.parseAndLogError)(err, `getTotalAlertsCountAggregations`, logger);
    return {
      hasErrors: true,
      errorMessage,
      count_alerts_total: 0,
      count_alerts_by_rule_type: {},
      count_ignored_fields_by_rule_type: {}
    };
  }
}