"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTrackedExecutions = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTrackedExecutions = ({
  trackedExecutions,
  currentExecution,
  limit
}) => {
  const trackedExecutionsArray = Array.from(trackedExecutions !== null && trackedExecutions !== void 0 ? trackedExecutions : []);
  trackedExecutionsArray.push(currentExecution);
  if (trackedExecutionsArray.length > limit) {
    trackedExecutionsArray.shift();
  }
  return trackedExecutionsArray;
};
exports.getTrackedExecutions = getTrackedExecutions;