"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unsnoozeRuleRoute = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _unsnooze = require("../../../../../../common/routes/rule/apis/unsnooze");
var _lib = require("../../../../../lib");
var _lib2 = require("../../../../lib");
var _types = require("../../../../../types");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const unsnoozeRuleRoute = (router, licenseState) => {
  router.delete({
    path: `${_types.BASE_ALERTING_API_PATH}/rule/{ruleId}/snooze_schedule/{scheduleId}`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'public',
      summary: 'Delete a snooze schedule for a rule',
      tags: ['oas-tag:alerting'],
      availability: {
        since: '8.19.0',
        stability: 'stable'
      }
    },
    validate: {
      request: {
        params: _unsnooze.unsnoozeParamsSchema
      },
      response: {
        204: {
          description: 'Indicates a successful call.'
        },
        400: {
          description: 'Indicates an invalid schema.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        },
        404: {
          description: 'Indicates a rule with the given id does not exist.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const {
      ruleId,
      scheduleId
    } = req.params;
    try {
      var _currentRule$snoozeSc, _currentRule$snoozeSc2;
      const currentRule = await rulesClient.get({
        id: ruleId
      });
      if (!((_currentRule$snoozeSc = currentRule.snoozeSchedule) !== null && _currentRule$snoozeSc !== void 0 && _currentRule$snoozeSc.length)) {
        throw _boom.default.badRequest('Rule has no snooze schedules.');
      }
      const scheduleToUnsnooze = (_currentRule$snoozeSc2 = currentRule.snoozeSchedule) === null || _currentRule$snoozeSc2 === void 0 ? void 0 : _currentRule$snoozeSc2.find(schedule => schedule.id === scheduleId);
      if (!scheduleToUnsnooze) {
        throw _boom.default.notFound(`Rule has no snooze schedule with id ${scheduleId}.`);
      }
      await rulesClient.unsnooze({
        id: ruleId,
        scheduleIds: [scheduleId]
      });
      return res.noContent();
    } catch (e) {
      if (e instanceof _lib.RuleMutedError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  })));
};
exports.unsnoozeRuleRoute = unsnoozeRuleRoute;