"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMaintenanceWindowRoute = void 0;
var _lib = require("../../../../lib");
var _types = require("../../../../../types");
var _common = require("../../../../../../common");
var _create = require("../../../../../../common/routes/maintenance_window/external/apis/create");
var _response = require("../../../../../../common/routes/maintenance_window/external/response");
var _transforms = require("../common/transforms");
var _transform_create_body = require("./transform_create_body");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMaintenanceWindowRoute = (router, licenseState) => {
  router.post({
    path: _types.CREATE_MAINTENANCE_WINDOW_API_PATH,
    validate: {
      request: {
        body: _create.createMaintenanceWindowRequestBodySchemaV1
      },
      response: {
        200: {
          body: () => _response.maintenanceWindowResponseSchemaV1,
          description: 'Indicates a successful call.'
        },
        400: {
          description: 'Indicates an invalid schema or parameters.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        }
      }
    },
    security: {
      authz: {
        requiredPrivileges: [`${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.WRITE_MAINTENANCE_WINDOW}`]
      }
    },
    options: {
      access: 'public',
      summary: 'Create a maintenance window.',
      tags: ['oas-tag:maintenance-window'],
      availability: {
        since: '8.19.0',
        stability: 'stable'
      }
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForMaintenanceWindow();
    const body = req.body;
    const maintenanceWindowClient = (await context.alerting).getMaintenanceWindowClient();
    const maintenanceWindow = await maintenanceWindowClient.create({
      data: (0, _transform_create_body.transformCreateBodyV1)(body)
    });
    const response = (0, _transforms.transformInternalMaintenanceWindowToExternalV1)(maintenanceWindow);
    return res.ok({
      body: response
    });
  })));
};
exports.createMaintenanceWindowRoute = createMaintenanceWindowRoute;