"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewTypeSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const viewTypeOptions = [{
  id: `charts`,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.embeddableChangePointChart.viewTypeSelector.chartsLabel",
    defaultMessage: "Charts"
  }),
  iconType: 'visLine'
}, {
  id: `table`,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.embeddableChangePointChart.viewTypeSelector.tableLabel",
    defaultMessage: "Table"
  }),
  iconType: 'visTable'
}];
const ViewTypeSelector = ({
  value,
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.aiops.embeddableChangePointChart.viewTypeLabel', {
      defaultMessage: 'View type'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: "This is a basic group",
    options: viewTypeOptions,
    idSelected: value,
    onChange: onChange
  }));
};
exports.ViewTypeSelector = ViewTypeSelector;