"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getChartsTheme = getChartsTheme;
const amsterdam_dark_theme_1 = require("./amsterdam_dark_theme");
const amsterdam_light_theme_1 = require("./amsterdam_light_theme");
const dark_theme_1 = require("./dark_theme");
const light_theme_1 = require("./light_theme");
function getChartsTheme(theme, colorMode) {
    const { name, darkMode } = typeof theme !== 'string' ? theme : { name: theme, darkMode: colorMode === 'DARK' };
    if (name.toLowerCase().includes('amsterdam'))
        return darkMode ? amsterdam_dark_theme_1.AMSTERDAM_DARK_THEME : amsterdam_light_theme_1.AMSTERDAM_LIGHT_THEME;
    return darkMode ? dark_theme_1.DARK_THEME : light_theme_1.LIGHT_THEME;
}
//# sourceMappingURL=get_charts_theme.js.map