"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compile = compile;
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const dateMathPlusSignRegex = /(%7C%7C[^%+]*?)\+/g; // "||+" after "||" is encoded as "%7C%7C"

async function compile(urlTemplate, context, doEncode = true) {
  const {
    handlebars
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./handlebars')));
  const {
    compileFnName
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/handlebars')));
  const handlebarsTemplate = handlebars[compileFnName](urlTemplate, {
    strict: true,
    noEscape: true
  });
  let processedUrl = handlebarsTemplate(context);
  if (doEncode) {
    // Replace "+" with "%2B" only if it's after a pipe "||", which means it's part of a date math expression
    processedUrl = encodeURI(processedUrl).replace(dateMathPlusSignRegex, '$1%2B');
  }
  return processedUrl;
}