"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.txtIncompatibleTooltip = exports.TriggerLineItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _text_with_icon = require("../text_with_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const txtIncompatibleTooltip = exports.txtIncompatibleTooltip = _i18n.i18n.translate('uiActionsEnhanced.components.TriggerLineItem.incompatibleTooltip', {
  defaultMessage: 'This trigger type not supported by this panel'
});
const TriggerLineItem = ({
  tooltip,
  incompatible,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_text_with_icon.TextWithIcon, {
    color: 'subdued',
    tooltip: tooltip,
    icon: incompatible ? 'warning' : undefined,
    iconColor: incompatible ? 'danger' : undefined,
    iconTooltip: incompatible ? txtIncompatibleTooltip : undefined
  }, children);
};
exports.TriggerLineItem = TriggerLineItem;