"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextWithIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TextWithIcon = ({
  color,
  tooltip,
  icon,
  iconColor,
  iconTooltip,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: 's'
  }, !!icon && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !!iconTooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: iconTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: iconColor,
    type: icon
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: iconColor,
    type: icon
  })), !!children && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      flexWrap: 'wrap'
    }
  }, tooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: color
  }, children)) : /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: color
  }, children)));
};
exports.TextWithIcon = TextWithIcon;