"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TECH_PREVIEW_LABEL = exports.TECH_PREVIEW_DESCRIPTION = exports.SHOW_REQUEST_MODAL_TITLE = exports.SHOW_REQUEST_MODAL_SUBTITLE = exports.SHOW_REQUEST_MODAL_ERROR = exports.MAINTENANCE_WINDOWS = exports.CASES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CASES = exports.CASES = _i18n.i18n.translate('xpack.triggersActionsUI.cases.label', {
  defaultMessage: 'Cases'
});
const MAINTENANCE_WINDOWS = exports.MAINTENANCE_WINDOWS = _i18n.i18n.translate('xpack.triggersActionsUI.maintenanceWindows.label', {
  defaultMessage: 'Maintenance Windows'
});
const TECH_PREVIEW_LABEL = exports.TECH_PREVIEW_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.technicalPreviewBadgeLabel', {
  defaultMessage: 'Technical preview'
});
const TECH_PREVIEW_DESCRIPTION = exports.TECH_PREVIEW_DESCRIPTION = _i18n.i18n.translate('xpack.triggersActionsUI.technicalPreviewBadgeDescription', {
  defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
});
const SHOW_REQUEST_MODAL_EDIT = _i18n.i18n.translate('xpack.triggersActionsUI.sections.showRequestModal.subheadingTitleEdit', {
  defaultMessage: 'edit'
});
const SHOW_REQUEST_MODAL_CREATE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.showRequestModal.subheadingTitleCreate', {
  defaultMessage: 'create'
});
const SHOW_REQUEST_MODAL_SUBTITLE = edit => _i18n.i18n.translate('xpack.triggersActionsUI.sections.showRequestModal.subheadingTitle', {
  defaultMessage: 'This Kibana request will {requestType} this rule.',
  values: {
    requestType: edit ? SHOW_REQUEST_MODAL_EDIT : SHOW_REQUEST_MODAL_CREATE
  }
});
exports.SHOW_REQUEST_MODAL_SUBTITLE = SHOW_REQUEST_MODAL_SUBTITLE;
const SHOW_REQUEST_MODAL_TITLE_EDIT = _i18n.i18n.translate('xpack.triggersActionsUI.sections.showRequestModal.headerTitleEdit', {
  defaultMessage: 'Edit'
});
const SHOW_REQUEST_MODAL_TITLE_CREATE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.showRequestModal.headerTitleCreate', {
  defaultMessage: 'Create'
});
const SHOW_REQUEST_MODAL_TITLE = edit => _i18n.i18n.translate('xpack.triggersActionsUI.sections.showRequestModal.headerTitle', {
  defaultMessage: '{requestType} alerting rule request',
  values: {
    requestType: edit ? SHOW_REQUEST_MODAL_TITLE_EDIT : SHOW_REQUEST_MODAL_TITLE_CREATE
  }
});
exports.SHOW_REQUEST_MODAL_TITLE = SHOW_REQUEST_MODAL_TITLE;
const SHOW_REQUEST_MODAL_ERROR = exports.SHOW_REQUEST_MODAL_ERROR = _i18n.i18n.translate('xpack.triggersActionsUI.sections.showRequestModal.somethingWentWrongDescription', {
  defaultMessage: 'Sorry about that, something went wrong.'
});