"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rulesWarningReasonTranslationsMapping = exports.rulesStatusesTranslationsMapping = exports.rulesLastRunOutcomeTranslationMapping = exports.rulesErrorReasonTranslationsMapping = exports.getSuccessfulEnablingNotificationText = exports.getSuccessfulDisablingNotificationText = exports.getSuccessfulDeletionNotificationText = exports.getPartialSuccessEnablingNotificationText = exports.getPartialSuccessDisablingNotificationText = exports.getPartialSuccessDeletionNotificationText = exports.getFailedEnablingNotificationText = exports.getFailedDisablingNotificationText = exports.getFailedDeletionNotificationText = exports.getConfirmDeletionModalText = exports.getConfirmDeletionButtonText = exports.TOTAL_RULES = exports.SINGLE_RULE_TITLE = exports.SELECT_SHOW_BULK_ACTIONS_ARIA_LABEL = exports.SELECT_ALL_RULES = exports.SELECT_ALL_ARIA_LABEL = exports.SELECTED_RULES = exports.RULE_STATUS_WARNING = exports.RULE_STATUS_UNKNOWN = exports.RULE_STATUS_PENDING = exports.RULE_STATUS_OK = exports.RULE_STATUS_ERROR = exports.RULE_STATUS_ACTIVE = exports.RULE_LAST_RUN_OUTCOME_WARNING_DESCRIPTION = exports.RULE_LAST_RUN_OUTCOME_WARNING = exports.RULE_LAST_RUN_OUTCOME_SUCCEEDED_DESCRIPTION = exports.RULE_LAST_RUN_OUTCOME_SUCCEEDED = exports.RULE_LAST_RUN_OUTCOME_FAILED_DESCRIPTION = exports.RULE_LAST_RUN_OUTCOME_FAILED = exports.MULTIPLE_RULE_TITLE = exports.CLEAR_SELECTION = exports.CLEAR_FILTERS = exports.CANCEL_BUTTON_TEXT = exports.ALERT_WARNING_UNKNOWN_REASON = exports.ALERT_WARNING_MAX_QUEUED_ACTIONS_REASON = exports.ALERT_WARNING_MAX_EXECUTABLE_ACTIONS_REASON = exports.ALERT_WARNING_MAX_ALERTS_REASON = exports.ALERT_WARNING_EXECUTION_REASON = exports.ALERT_STATUS_WARNING = exports.ALERT_STATUS_UNKNOWN = exports.ALERT_STATUS_PENDING = exports.ALERT_STATUS_OK = exports.ALERT_STATUS_LICENSE_ERROR = exports.ALERT_STATUS_ERROR = exports.ALERT_STATUS_ACTIVE = exports.ALERT_ERROR_VALIDATE_REASON = exports.ALERT_ERROR_UNKNOWN_REASON = exports.ALERT_ERROR_TIMEOUT_REASON = exports.ALERT_ERROR_READING_REASON = exports.ALERT_ERROR_LICENSE_REASON = exports.ALERT_ERROR_EXECUTION_REASON = exports.ALERT_ERROR_DISABLED_REASON = exports.ALERT_ERROR_DECRYPTING_REASON = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_STATUS_OK = exports.ALERT_STATUS_OK = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleStatusOk', {
  defaultMessage: 'Ok'
});
const ALERT_STATUS_ACTIVE = exports.ALERT_STATUS_ACTIVE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleStatusActive', {
  defaultMessage: 'Active'
});
const ALERT_STATUS_ERROR = exports.ALERT_STATUS_ERROR = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleStatusError', {
  defaultMessage: 'Error'
});
const ALERT_STATUS_LICENSE_ERROR = exports.ALERT_STATUS_LICENSE_ERROR = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleStatusLicenseError', {
  defaultMessage: 'License Error'
});
const ALERT_STATUS_PENDING = exports.ALERT_STATUS_PENDING = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleStatusPending', {
  defaultMessage: 'Pending'
});
const ALERT_STATUS_UNKNOWN = exports.ALERT_STATUS_UNKNOWN = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleStatusUnknown', {
  defaultMessage: 'Unknown'
});
const ALERT_STATUS_WARNING = exports.ALERT_STATUS_WARNING = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleStatusWarning', {
  defaultMessage: 'Warning'
});
const RULE_LAST_RUN_OUTCOME_SUCCEEDED = exports.RULE_LAST_RUN_OUTCOME_SUCCEEDED = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleLastRunOutcomeSucceeded', {
  defaultMessage: 'Succeeded'
});
const RULE_LAST_RUN_OUTCOME_WARNING = exports.RULE_LAST_RUN_OUTCOME_WARNING = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleLastRunOutcomeWarning', {
  defaultMessage: 'Warning'
});
const RULE_LAST_RUN_OUTCOME_FAILED = exports.RULE_LAST_RUN_OUTCOME_FAILED = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleLastRunOutcomeFailed', {
  defaultMessage: 'Failed'
});
const rulesStatusesTranslationsMapping = exports.rulesStatusesTranslationsMapping = {
  ok: ALERT_STATUS_OK,
  active: ALERT_STATUS_ACTIVE,
  error: ALERT_STATUS_ERROR,
  pending: ALERT_STATUS_PENDING,
  unknown: ALERT_STATUS_UNKNOWN,
  warning: ALERT_STATUS_WARNING
};
const rulesLastRunOutcomeTranslationMapping = exports.rulesLastRunOutcomeTranslationMapping = {
  succeeded: RULE_LAST_RUN_OUTCOME_SUCCEEDED,
  warning: RULE_LAST_RUN_OUTCOME_WARNING,
  failed: RULE_LAST_RUN_OUTCOME_FAILED
};
const ALERT_ERROR_UNKNOWN_REASON = exports.ALERT_ERROR_UNKNOWN_REASON = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleErrorReasonUnknown', {
  defaultMessage: 'An error occurred for unknown reasons.'
});
const ALERT_ERROR_READING_REASON = exports.ALERT_ERROR_READING_REASON = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleErrorReasonReading', {
  defaultMessage: 'An error occurred when reading the rule.'
});
const ALERT_ERROR_DECRYPTING_REASON = exports.ALERT_ERROR_DECRYPTING_REASON = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleErrorReasonDecrypting', {
  defaultMessage: 'An error occurred when decrypting the rule.'
});
const ALERT_ERROR_EXECUTION_REASON = exports.ALERT_ERROR_EXECUTION_REASON = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleErrorReasonRunning', {
  defaultMessage: 'An error occurred when running the rule.'
});
const ALERT_ERROR_LICENSE_REASON = exports.ALERT_ERROR_LICENSE_REASON = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleErrorReasonLicense', {
  defaultMessage: 'Cannot run rule'
});
const ALERT_ERROR_TIMEOUT_REASON = exports.ALERT_ERROR_TIMEOUT_REASON = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleErrorReasonTimeout', {
  defaultMessage: 'Rule execution cancelled due to timeout.'
});
const ALERT_ERROR_DISABLED_REASON = exports.ALERT_ERROR_DISABLED_REASON = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleErrorReasonDisabled', {
  defaultMessage: 'Rule failed to execute because rule ran after it was disabled.'
});
const ALERT_ERROR_VALIDATE_REASON = exports.ALERT_ERROR_VALIDATE_REASON = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleErrorReasonValidate', {
  defaultMessage: 'An error occurred when validating the rule parameters.'
});
const ALERT_WARNING_MAX_EXECUTABLE_ACTIONS_REASON = exports.ALERT_WARNING_MAX_EXECUTABLE_ACTIONS_REASON = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleWarningReasonMaxExecutableActions', {
  defaultMessage: 'Action limit exceeded'
});
const ALERT_WARNING_MAX_QUEUED_ACTIONS_REASON = exports.ALERT_WARNING_MAX_QUEUED_ACTIONS_REASON = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleWarningReasonMaxQueuedActions', {
  defaultMessage: 'Queued action limit exceeded.'
});
const ALERT_WARNING_MAX_ALERTS_REASON = exports.ALERT_WARNING_MAX_ALERTS_REASON = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleWarningReasonMaxAlerts', {
  defaultMessage: 'Alert limit exceeded'
});
const ALERT_WARNING_UNKNOWN_REASON = exports.ALERT_WARNING_UNKNOWN_REASON = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleWarningReasonUnknown', {
  defaultMessage: 'Unknown reason'
});
const ALERT_WARNING_EXECUTION_REASON = exports.ALERT_WARNING_EXECUTION_REASON = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.ruleWarningReasonExecution', {
  defaultMessage: 'Rule execution warning.'
});
const rulesErrorReasonTranslationsMapping = exports.rulesErrorReasonTranslationsMapping = {
  read: ALERT_ERROR_READING_REASON,
  decrypt: ALERT_ERROR_DECRYPTING_REASON,
  execute: ALERT_ERROR_EXECUTION_REASON,
  unknown: ALERT_ERROR_UNKNOWN_REASON,
  license: ALERT_ERROR_LICENSE_REASON,
  timeout: ALERT_ERROR_TIMEOUT_REASON,
  disabled: ALERT_ERROR_DISABLED_REASON,
  validate: ALERT_ERROR_VALIDATE_REASON
};
const rulesWarningReasonTranslationsMapping = exports.rulesWarningReasonTranslationsMapping = {
  maxExecutableActions: ALERT_WARNING_MAX_EXECUTABLE_ACTIONS_REASON,
  maxAlerts: ALERT_WARNING_MAX_ALERTS_REASON,
  maxQueuedActions: ALERT_WARNING_MAX_QUEUED_ACTIONS_REASON,
  unknown: ALERT_WARNING_UNKNOWN_REASON,
  ruleExecution: ALERT_WARNING_EXECUTION_REASON
};
const SELECT_ALL_ARIA_LABEL = exports.SELECT_ALL_ARIA_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.selectAllAriaLabel', {
  defaultMessage: 'Toggle select all rules'
});
const SELECT_SHOW_BULK_ACTIONS_ARIA_LABEL = exports.SELECT_SHOW_BULK_ACTIONS_ARIA_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.selectShowBulkActionsAriaLabel', {
  defaultMessage: 'Show bulk actions'
});
const TOTAL_RULES = (formattedTotalRules, totalRules) => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.totalRulesLabel', {
    values: {
      formattedTotalRules,
      totalRules
    },
    defaultMessage: '{formattedTotalRules} {totalRules, plural, =1 {rule} other {rules}}'
  });
};
exports.TOTAL_RULES = TOTAL_RULES;
const SELECTED_RULES = (formattedSelectedRules, selectedRules) => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.selectedRulesButton', {
    values: {
      formattedSelectedRules,
      selectedRules
    },
    defaultMessage: 'Selected {formattedSelectedRules} {selectedRules, plural, =1 {rule} other {rules}}'
  });
};
exports.SELECTED_RULES = SELECTED_RULES;
const SELECT_ALL_RULES = (formattedTotalRules, totalRules) => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.selectAllRulesButton', {
    values: {
      formattedTotalRules,
      totalRules
    },
    defaultMessage: 'Select all {formattedTotalRules} {totalRules, plural, =1 {rule} other {rules}}'
  });
};
exports.SELECT_ALL_RULES = SELECT_ALL_RULES;
const CLEAR_SELECTION = exports.CLEAR_SELECTION = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.clearAllSelectionButton', {
  defaultMessage: 'Clear selection'
});
const RULE_STATUS_ACTIVE = total => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.totalStatusesActiveDescription', {
    defaultMessage: 'Active: {totalStatusesActive}',
    values: {
      totalStatusesActive: total
    }
  });
};
exports.RULE_STATUS_ACTIVE = RULE_STATUS_ACTIVE;
const RULE_STATUS_ERROR = total => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.totalStatusesErrorDescription', {
    defaultMessage: 'Error: {totalStatusesError}',
    values: {
      totalStatusesError: total
    }
  });
};
exports.RULE_STATUS_ERROR = RULE_STATUS_ERROR;
const RULE_STATUS_WARNING = total => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.totalStatusesWarningDescription', {
    defaultMessage: 'Warning: {totalStatusesWarning}',
    values: {
      totalStatusesWarning: total
    }
  });
};
exports.RULE_STATUS_WARNING = RULE_STATUS_WARNING;
const RULE_STATUS_OK = total => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.totalStatusesOkDescription', {
    defaultMessage: 'Ok: {totalStatusesOk}',
    values: {
      totalStatusesOk: total
    }
  });
};
exports.RULE_STATUS_OK = RULE_STATUS_OK;
const RULE_STATUS_PENDING = total => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.totalStatusesPendingDescription', {
    defaultMessage: 'Pending: {totalStatusesPending}',
    values: {
      totalStatusesPending: total
    }
  });
};
exports.RULE_STATUS_PENDING = RULE_STATUS_PENDING;
const RULE_STATUS_UNKNOWN = total => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.totalStatusesUnknownDescription', {
    defaultMessage: 'Unknown: {totalStatusesUnknown}',
    values: {
      totalStatusesUnknown: total
    }
  });
};
exports.RULE_STATUS_UNKNOWN = RULE_STATUS_UNKNOWN;
const RULE_LAST_RUN_OUTCOME_SUCCEEDED_DESCRIPTION = total => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.lastRunOutcomeSucceededDescription', {
    defaultMessage: 'Succeeded: {total}',
    values: {
      total
    }
  });
};
exports.RULE_LAST_RUN_OUTCOME_SUCCEEDED_DESCRIPTION = RULE_LAST_RUN_OUTCOME_SUCCEEDED_DESCRIPTION;
const RULE_LAST_RUN_OUTCOME_WARNING_DESCRIPTION = total => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.lastRunOutcomeWarningDescription', {
    defaultMessage: 'Warning: {total}',
    values: {
      total
    }
  });
};
exports.RULE_LAST_RUN_OUTCOME_WARNING_DESCRIPTION = RULE_LAST_RUN_OUTCOME_WARNING_DESCRIPTION;
const RULE_LAST_RUN_OUTCOME_FAILED_DESCRIPTION = total => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.lastRunOutcomeFailedDescription', {
    defaultMessage: 'Failed: {total}',
    values: {
      total
    }
  });
};
exports.RULE_LAST_RUN_OUTCOME_FAILED_DESCRIPTION = RULE_LAST_RUN_OUTCOME_FAILED_DESCRIPTION;
const SINGLE_RULE_TITLE = exports.SINGLE_RULE_TITLE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.singleTitle', {
  defaultMessage: 'rule'
});
const MULTIPLE_RULE_TITLE = exports.MULTIPLE_RULE_TITLE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.multipleTitle', {
  defaultMessage: 'rules'
});
const CANCEL_BUTTON_TEXT = exports.CANCEL_BUTTON_TEXT = _i18n.i18n.translate('xpack.triggersActionsUI.deleteSelectedIdsConfirmModal.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
const CLEAR_FILTERS = numberOfFilters => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.clearFilterLink', {
    values: {
      numberOfFilters
    },
    defaultMessage: 'Clear {numberOfFilters, plural, =1 {filter} other {filters}}'
  });
};
exports.CLEAR_FILTERS = CLEAR_FILTERS;
const getConfirmDeletionModalText = (numIdsToDelete, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.triggersActionsUI.deleteSelectedIdsConfirmModal.descriptionText', {
  defaultMessage: "You won't be able to recover {numIdsToDelete, plural, one {a deleted {singleTitle}} other {deleted {multipleTitle}}}.",
  values: {
    numIdsToDelete,
    singleTitle,
    multipleTitle
  }
});
exports.getConfirmDeletionModalText = getConfirmDeletionModalText;
const getConfirmDeletionButtonText = (numIdsToDelete, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.triggersActionsUI.deleteSelectedIdsConfirmModal.deleteButtonLabel', {
  defaultMessage: 'Delete {numIdsToDelete, plural, one {{singleTitle}} other {# {multipleTitle}}} ',
  values: {
    numIdsToDelete,
    singleTitle,
    multipleTitle
  }
});
exports.getConfirmDeletionButtonText = getConfirmDeletionButtonText;
const getSuccessfulDeletionNotificationText = (numSuccesses, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.triggersActionsUI.components.deleteSelectedIdsSuccessNotification.descriptionText', {
  defaultMessage: 'Deleted {numSuccesses, number} {numSuccesses, plural, one {{singleTitle}} other {{multipleTitle}}}',
  values: {
    numSuccesses,
    singleTitle,
    multipleTitle
  }
});
exports.getSuccessfulDeletionNotificationText = getSuccessfulDeletionNotificationText;
const getSuccessfulEnablingNotificationText = (numSuccesses, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.triggersActionsUI.components.enableSelectedIdsSuccessNotification.descriptionText', {
  defaultMessage: 'Enabled {numSuccesses, number} {numSuccesses, plural, one {{singleTitle}} other {{multipleTitle}}}',
  values: {
    numSuccesses,
    singleTitle,
    multipleTitle
  }
});
exports.getSuccessfulEnablingNotificationText = getSuccessfulEnablingNotificationText;
const getSuccessfulDisablingNotificationText = (numSuccesses, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.triggersActionsUI.components.disableSelectedIdsSuccessNotification.descriptionText', {
  defaultMessage: 'Disabled {numSuccesses, number} {numSuccesses, plural, one {{singleTitle}} other {{multipleTitle}}}',
  values: {
    numSuccesses,
    singleTitle,
    multipleTitle
  }
});
exports.getSuccessfulDisablingNotificationText = getSuccessfulDisablingNotificationText;
const getFailedDeletionNotificationText = (numErrors, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.triggersActionsUI.components.deleteSelectedIdsErrorNotification.descriptionText', {
  defaultMessage: 'Failed to delete {numErrors, number} {numErrors, plural, one {{singleTitle}} other {{multipleTitle}}}',
  values: {
    numErrors,
    singleTitle,
    multipleTitle
  }
});
exports.getFailedDeletionNotificationText = getFailedDeletionNotificationText;
const getFailedEnablingNotificationText = (numErrors, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.triggersActionsUI.components.enableSelectedIdsErrorNotification.descriptionText', {
  defaultMessage: 'Failed to enable {numErrors, number} {numErrors, plural, one {{singleTitle}} other {{multipleTitle}}}',
  values: {
    numErrors,
    singleTitle,
    multipleTitle
  }
});
exports.getFailedEnablingNotificationText = getFailedEnablingNotificationText;
const getFailedDisablingNotificationText = (numErrors, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.triggersActionsUI.components.disableSelectedIdsErrorNotification.descriptionText', {
  defaultMessage: 'Failed to disable {numErrors, number} {numErrors, plural, one {{singleTitle}} other {{multipleTitle}}}',
  values: {
    numErrors,
    singleTitle,
    multipleTitle
  }
});
exports.getFailedDisablingNotificationText = getFailedDisablingNotificationText;
const getPartialSuccessDeletionNotificationText = (numberOfSuccess, numberOfErrors, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.triggersActionsUI.components.deleteSelectedIdsPartialSuccessNotification.descriptionText', {
  defaultMessage: 'Deleted {numberOfSuccess, number} {numberOfSuccess, plural, one {{singleTitle}} other {{multipleTitle}}}, {numberOfErrors, number} {numberOfErrors, plural, one {{singleTitle}} other {{multipleTitle}}} encountered errors',
  values: {
    numberOfSuccess,
    numberOfErrors,
    singleTitle,
    multipleTitle
  }
});
exports.getPartialSuccessDeletionNotificationText = getPartialSuccessDeletionNotificationText;
const getPartialSuccessEnablingNotificationText = (numberOfSuccess, numberOfErrors, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.triggersActionsUI.components.enableSelectedIdsPartialSuccessNotification.descriptionText', {
  defaultMessage: 'Enabled {numberOfSuccess, number} {numberOfSuccess, plural, one {{singleTitle}} other {{multipleTitle}}}, {numberOfErrors, number} {numberOfErrors, plural, one {{singleTitle}} other {{multipleTitle}}} encountered errors',
  values: {
    numberOfSuccess,
    numberOfErrors,
    singleTitle,
    multipleTitle
  }
});
exports.getPartialSuccessEnablingNotificationText = getPartialSuccessEnablingNotificationText;
const getPartialSuccessDisablingNotificationText = (numberOfSuccess, numberOfErrors, singleTitle, multipleTitle) => _i18n.i18n.translate('xpack.triggersActionsUI.components.disableSelectedIdsPartialSuccessNotification.descriptionText', {
  defaultMessage: 'Disabled {numberOfSuccess, number} {numberOfSuccess, plural, one {{singleTitle}} other {{multipleTitle}}}, {numberOfErrors, number} {numberOfErrors, plural, one {{singleTitle}} other {{multipleTitle}}} encountered errors',
  values: {
    numberOfSuccess,
    numberOfErrors,
    singleTitle,
    multipleTitle
  }
});
exports.getPartialSuccessDisablingNotificationText = getPartialSuccessDisablingNotificationText;