"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GlobalRuleEventLogList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rule_event_log_list_table = require("./rule_event_log_list_table");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEmptyFunctionComponent = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const GLOBAL_EVENT_LOG_LIST_STORAGE_KEY = 'xpack.triggersActionsUI.globalEventLogList.initialColumns';
const REFRESH_TOKEN = {
  resolve: () => {
    /* noop */
  },
  reject: () => {
    /* noop */
  }
};
const GlobalRuleEventLogList = props => {
  const {
    localStorageKey,
    filteredRuleTypes,
    getRuleDetailsRoute
  } = props;
  const {
    spaces
  } = (0, _kibana.useKibana)().services;

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const SpacesContextWrapper = (0, _react.useCallback)(spaces ? spaces.ui.components.getSpacesContextProvider : getEmptyFunctionComponent, [spaces]);
  return /*#__PURE__*/_react.default.createElement(SpacesContextWrapper, {
    feature: "triggersActions"
  }, /*#__PURE__*/_react.default.createElement(_rule_event_log_list_table.RuleEventLogListTable, {
    ruleId: '*',
    refreshToken: REFRESH_TOKEN,
    initialPageSize: 50,
    hasRuleNames: true,
    hasAllSpaceSwitch: true,
    localStorageKey: localStorageKey || GLOBAL_EVENT_LOG_LIST_STORAGE_KEY,
    filteredRuleTypes: filteredRuleTypes,
    getRuleDetailsRoute: getRuleDetailsRoute
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.GlobalRuleEventLogList = GlobalRuleEventLogList;