"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionDurationChart = void 0;
exports.padOrTruncateDurations = padOrTruncateDurations;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _execution_duration_utils = require("../../../lib/execution_duration_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NUM_EXECUTIONS_OPTIONS = [120, 60, 30, 15].map(value => ({
  value,
  text: _i18n.i18n.translate('xpack.triggersActionsUI.sections.executionDurationChart.numberOfExecutionsOption', {
    defaultMessage: '{value} runs',
    values: {
      value
    }
  })
}));
const ExecutionDurationChart = ({
  executionDuration,
  numberOfExecutions,
  onChangeDuration,
  isLoading
}) => {
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const paddedExecutionDurations = padOrTruncateDurations(executionDuration.valuesWithTimestamp, numberOfExecutions);
  const onChange = (0, _react.useCallback)(({
    target
  }) => onChangeDuration(Number(target.value)), [onChangeDuration]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "executionDurationChartPanel",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.executionDurationChart.recentDurationsTitle",
    defaultMessage: "Recent run durations"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    id: "select-number-execution-durations",
    "data-test-subj": "executionDurationChartPanelSelect",
    options: NUM_EXECUTIONS_OPTIONS,
    value: numberOfExecutions,
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.executionDurationChart.selectNumberOfExecutionDurationsLabel', {
      defaultMessage: 'Select number of runs'
    }),
    onChange: onChange
  })))), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      height: '80px',
      justifyContent: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "xl"
  }))), !isLoading && (executionDuration.valuesWithTimestamp && Object.entries(executionDuration.valuesWithTimestamp).length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    "data-test-subj": "executionDurationChart",
    size: {
      height: 80
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: {
      lineSeriesStyle: {
        point: {
          visible: 'never'
        },
        line: {
          stroke: _uiTheme.euiLightVars.euiColorAccent
        }
      }
    },
    baseTheme: chartBaseTheme,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "executionDuration",
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.executionDurationChart.durationLabel', {
      defaultMessage: `Duration`
    }),
    xScaleType: "linear",
    yScaleType: "linear",
    xAccessor: 0,
    yAccessors: [1],
    data: paddedExecutionDurations.map(([timestamp, val], ndx) => [timestamp ? (0, _moment.default)(timestamp).format('D MMM YYYY @ HH:mm:ss') : ndx, val]),
    minBarHeight: 2
  }), /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: "rule_duration_avg",
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.executionDurationChart.avgDurationLabel', {
      defaultMessage: `Avg Duration`
    }),
    xScaleType: "linear",
    yScaleType: "linear",
    xAccessor: 0,
    yAccessors: [1],
    data: paddedExecutionDurations.map(([timestamp, val], ndx) => [timestamp ? (0, _moment.default)(timestamp).format('D MMM YYYY @ HH:mm:ss') : ndx, val ? executionDuration.average : null]),
    curve: _charts.CurveType.CURVE_NATURAL
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left-axis",
    position: "left",
    tickFormat: d => (0, _execution_duration_utils.formatMillisForDisplay)(d)
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "executionDurationChartEmpty",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.executionDurationChart.executionDurationNoData",
      defaultMessage: "There is no available run duration information for this rule."
    })))
  }))));
};
exports.ExecutionDurationChart = ExecutionDurationChart;
function padOrTruncateDurations(valuesWithTimestamp, desiredSize) {
  const values = Object.entries(valuesWithTimestamp);
  if (values.length === desiredSize) {
    return values;
  } else if (values.length < desiredSize) {
    return (0, _lodash.assign)((0, _lodash.fill)(new Array(desiredSize), [null, null]), values);
  } else {
    // oldest durations are at the start of the array, so take the last {desiredSize} values
    return values.slice(-desiredSize);
  }
}