"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFlappingSettings = void 0;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteBodyRes = ({
  look_back_window: lookBackWindow,
  status_change_threshold: statusChangeThreshold,
  ...rest
}) => ({
  ...rest,
  lookBackWindow,
  statusChangeThreshold
});
const updateFlappingSettings = async ({
  http,
  flappingSettings
}) => {
  let body;
  try {
    body = JSON.stringify({
      enabled: flappingSettings.enabled,
      look_back_window: flappingSettings.lookBackWindow,
      status_change_threshold: flappingSettings.statusChangeThreshold
    });
  } catch (e) {
    throw new Error(`Unable to parse flapping settings update params: ${e}`);
  }
  const res = await http.post(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rules/settings/_flapping`, {
    body
  });
  return rewriteBodyRes(res);
};
exports.updateFlappingSettings = updateFlappingSettings;