"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleTypeAlertFields = useRuleTypeAlertFields;
var _react = require("react");
var _ecs = require("@elastic/ecs");
var _fetch_rule_type_alert_fields = require("@kbn/alerts-ui-shared/src/common/apis/fetch_rule_type_alert_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useRuleTypeAlertFields(http, ruleTypeId, enabled) {
  // Reimplement useQuery here; this hook is sometimes called in contexts without a QueryClientProvider
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [data, setData] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    if (enabled && data.length === 0 && ruleTypeId) {
      setIsLoading(true);
      (0, _fetch_rule_type_alert_fields.fetchRuleTypeAlertFields)({
        http,
        ruleTypeId
      }).then(res => {
        setData(res);
        setIsLoading(false);
      });
    }
  }, [data, enabled, http, ruleTypeId]);
  return (0, _react.useMemo)(() => ({
    isLoading,
    fields: data.map(d => ({
      name: d.name,
      description: (0, _fetch_rule_type_alert_fields.getDescription)(d.name, _ecs.EcsFlat)
    }))
  }), [data, isLoading]);
}